<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?="Settings"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='bluvault'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('listOfBluvaults', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="row col-lg-12">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center">BluVault Name</th>
                                </tr>
                            </thead>
                            <tbody class="text-center bluvaultListTable">
                                <tr ng-if="bluvaults.length == 1" ng-repeat="value in bluvaults track by $index">
                                    <td><span class="text-center" ng-cloak>{{ value.bluVaultName }}</span></td>
                                </tr>
                                <tr ng-if="bluvaults.length > 1" ng-repeat="value in bluvaults">
                                    <td>
                                        <span class="text-center" ng-cloak>{{ value.bluVaultName }}</span>
                                        <button ng-click="removeBluvault(value.id, $index)" class="btn btn-small btn-danger pull-right">remove</button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <?=
                                Form::open(array(
                                    'csrf' => $data['csrf_token'],
                                    'class' => 'filterForm',
                                    'autocomplete' => 'off',
                                    'ng-submit' => 'saveBluvault(bluvault)',
                                    'data-parsley-validate' => true
                                ));
                            ?>
                            <div class="form-group">
                                <label for="bluvault"><?=Language::show('create_new_bluvault', 'keywords');?></label>
                                <input type="text" class="form-control" ng-model="bluvault" name="bluvault" id="bluvault" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('bluvault', 'keywords');?>" required autocomplete="off">
                            </div>
                            <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                            <?=
                                Form::close();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>