<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=Language::show('list_of_filters', 'keywords')?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='filter'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('list_of_filters', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/filter/create')?>"><?=Language::show('create_filter', 'keywords');?></a></span></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-6">
                                    <col class="col-xs-2">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th class="text-left"><?=Language::show('filterName', 'keywords')?></th>
                                        <th class="text-left"><?=Language::show('filterType', 'keywords')?></th>
                                        <th class="text-left"><?=Language::show('filterExtension', 'keywords')?></th>
                                        <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in filters | orderBy:sortType:sortReverse track by $index">
                                        <td ng-cloak>{{ value.filterName }}</td>
                                        <td ng-cloak>{{ value.filterType }}</td>
                                        <td ng-cloak style="word-break: break-word;">{{ value.filters }}</td>
                                        <td ng-cloak class="text-left"><a class="btn btn-default btn-small btn-success" ng-click="filterEdit($index)"><i class="fa fa-edit"></i> <?=Language::show('edit', 'keywords')?></a>
<a ng-class="{false:'disabled'}[value.isdeletable]" class="btn btn-danger btn-small filterremove{{$index}}"
                                               ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Confirm Delete Filter</h4><hr></div><?=Language::show('confirmDelete', 'keywords')?> {{value.filterName}} <?=Language::show('filter', 'keywords')?> ?"
                                               ng-bootbox-confirm-action="removeFilter(value.filterName,$index)"
                                               ng-bootbox-confirm-action-cancel=""
                                               href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords')?></a>
					</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade editFilter">
            <div class="modal-dialog">
                <div class="modal-content mediumModal">
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'filterForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'filterSave()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Edit Filter</h4>
                    </div>
                    <div class="modal-body">
						<div class="form-group col-lg-12">
                            <label class="col-lg-3" for="defaultSchedules" style="margin-left: -30px;margin-top: 10px;"><?=Language::show('makeScheduleDefault', 'keywords');?></label>
                                <div>
                                    <label class="switch col-lg-9">
                                    <input id="switchfilter" name="defaultInclusionFilter" type="checkbox">
                                    <div class="slider round"></div>
                                    </label>
                                </div>
						</div>
                        <div class="form-group">
                            <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                            <input type="text" class="form-control" name="filterName" id="filterName" value="{{ filters[filterIndex].filterName }}" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group">
                            <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                            <select class="form-control filterType" name="filterType" id="filterType" required>
                                <option value="inclusion">Inclusion Filter</option>
                                <option value="exclusion">Exclusion Filter</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="filters"><?=Language::show('filterExtension', 'keywords');?></label><br/>
                            <input type="text" data-role="tagsinput" value="{{ filters[filterIndex].filters }}" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords')?></button>
                        <button type="submit" class="btn btn-primary"><?=Language::show('save', 'keywords')?></button>
                    </div>
                    <?= Form::close(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.filterType').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>