<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('pms/filters')?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=Language::show('create_filter', 'keywords')?></span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-2 col-md-2 col-sm-2">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('create_filter', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                        <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'filterForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'filterCreate(false)',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="form-group col-lg-12">
                            <label class="col-lg-2" for="defaultFilter" style="margin-left: -30px;margin-top: 10px;"><?=Language::show('makeFilterDefault', 'keywords');?></label>
                                <div>
                                    <label class="switch col-lg-10">
                                    <input id="switchfilter" name="defaultInclusionFilter" type="checkbox">
                                    <div class="slider round"></div>
                                    </label>
                                </div>
                        </div>
                        <div class="form-group">
                            <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                            <input type="text" class="form-control" name="filterName" id="filterName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group">
                            <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                            <select class="form-control filterType" name="filterType" id="filterType" required>
                                <option value="inclusion">Inclusion Filter</option>
                                <option value="exclusion">Exclusion Filter</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="filters"><?=Language::show('filterExtension', 'keywords');?></label><br/>
                            <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control" name="filters[]" id="filters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                        </div>
                        <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        <?=
                            Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.filterType').selectpicker('render');
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>