<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="MigrationController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='migrationDashboard'?></span>
            <div class="row dashboard">
                <div class="panel panel-default">
                    <div class="panel-heading"><h3>Migration Overview</h3></div>
                    <div class="panel-body">
                        <ul class="list-group col-lg-6">
                            <li class="list-group-item">Users On System <p class="pull-right" ng-cloak>{{ migrationDetails.noOfUsersMigrated }}</p></li>
                            <li class="list-group-item">Parablu End Point Agent Installed on <p class="pull-right" ng-cloak>{{ migrationDetails.noOfBSInstalled }}</p></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row dashboard">
                <div class="panel panel-default">
                    <div class="panel-heading"><h3>Migration Tools</h3></div>
                    <div class="panel-body">
                        <div class="col-lg-4">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('migratedStatus', 'migration');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="gotTo('/report/userMigration')">
                                <div class="background">
                                    <i class="fa fa-pie-chart"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                   <center><i class="fa fa-pie-chart"> Migration Status</i><br></center>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-4">
                        <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('importUsers', 'migration');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="gotTo('/migration/importUsers')">
                                <div class="background">
                                    <i class="fa fa-user-plus"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                   <center><i class="fa fa-user-plus"> Import Users</i><br></center>
                                </div>
                            </div>
                        </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/MigrationController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>