<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('myAccount/'.$data['currentUser'])?>"><?=Language::show('myAccount', 'keywords');?></a></li>
                    <li><span>Backup Activity History</span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="HistoryController">
        <span class="hide token"><?=$data['csrf_token']?></span>
        <span class="hide currentPage"><?='deviceBackupHistory'?></span>
        <span class="hide currentOs"><?=$data['os']?></span>
        <div class="row profile">
            <div class="col-lg-2 col-md-2 col-sm-2">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('backup_activity_history', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 10px 10px 10px;">
                        <div class="table-responsive">
                            <hr/>
                            <div>Summary - Total Number of Files : <span class="text-info">{{ summary.totalNoOfFiles }}</span>, Files to be backed up :  <span class="text-danger">{{ summary.noOfFilesToBeUploaded }}</span>, Percentage Completed : <span class="text-success">{{ summary.completedPercentage }}</span></div>
                            <hr/>
                            <div class="h4 loading text-center">Loading.....</div>
                            <table class="table table-bordered table-striped deviceHistoryTable" style="display: none;">
                                <colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-1">
                                    <col class="col-xs-4">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th><?=Language::show('start_time', 'keywords')?></th>
                                        <th><?=Language::show('end_time', 'keywords')?></th>
                                        <th><?=Language::show('attempted', 'keywords')?></th>
                                        <th><?=Language::show('success', 'keywords')?></th>
                                        <th><?=Language::show('failed', 'keywords')?></th>
                                        <th><?=Language::show('comments', 'keywords')?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in history track by $index">
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td ng-cloak>{{ value.endTime }}</td>
                                    <td><span class="text-info" ng-cloak>{{ value.totalFile }}</span></td>
                                    <!--<td><span class="text-success clickAble" ng-click="showHistoryDetails(value.batchId, 'Uploaded', value.percentage)" ng-cloak>{{ value.percentage }}</span></td>
                                    <td><span class="text-danger clickAble" ng-click="showHistoryDetails(value.batchId, 'Failed', value.failed)" ng-cloak>{{ value.failed }}</span></td>-->
                                    <td><span class="text-success" ng-cloak>{{ value.percentage }}</span></td>
                                    <td><span class="text-danger" ng-cloak>{{ value.failed }}</span></td>
                                    <td ng-cloak>{{ value.comments }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade backupHistoryDetailsModal whiteAndBigModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Backup History Details</h4>
                    </div>
                    <div class="modal-body">
                        <div class="table-responsive" style="margin-top: -20px;">
                            <hr/>
                            <div class="h4 loading text-center">Loading.....</div>
                            <table class="table table-bordered table-striped deviceHistoryDetailsTable" style="display: none;">
                                <colgroup>
                                    <col class="col-xs-3">
                                    <col class="col-xs-6">
                                    <col class="col-xs-2">
                                    <col class="col-xs-1">
                                </colgroup>
                                <thead>
                                <tr>
                                    <th><?=Language::show('file_name', 'keywords')?></th>
                                    <th><?=Language::show('file_path', 'keywords')?></th>
                                    <th><?=Language::show('file_size', 'keywords')?></th>
                                    <th><?=Language::show('status', 'keywords')?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in historyDetails | filterStatusType:historyDetailsType">
                                    <td ng-cloak>{{ value.fileName }}</td>
                                    <td ng-cloak>{{ value.filePath }}</td>
                                    <td><span class="text-info" ng-cloak>{{ value.size }}</span></td>
                                    <td ng-cloak>{{ value.status }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer" style="z-index: 10000000000;">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>