/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('MigrationController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'Upload', '$timeout', function($scope, toastr, $http, $ngBootbox, blockUI, BASE_FOLDER, Upload, $timeout) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.migrationDetails = {};
    $scope.userList = [];
    $scope.policy = '';
    $scope.selectedPolicy = '';

    $scope.updateMigrationDetails = function(){
        blockUI.start();
        $.ajax({
            url: $scope.BASE_FOLDER+'/migration',
            data: {secret: 'asd', csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            $scope.migrationDetails.noOfUsersMigrated = jData.details.headers.container.noOfUsersMigrated;
            $scope.migrationDetails.noOfBSInstalled = jData.details.headers.container.noOfBSInstalled;
            $scope.$apply();
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getUsers = function(policyName, syncPolicy){
        var userList = $('#userNames').tagsinput('items');
        var cloudType = $('input[name="migrationType"]:checked').val();
        if(cloudType == 'backup'){
            if(!policyName){
                toastr.info('Please select a Backup Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            syncPolicy = null;
        }

        else if(cloudType == 'sync'){
            if(!syncPolicy){
                toastr.info('Please select a Sync Policy', 'Information!!!', {allowHtml: true});
                return;
            }
            policyName = null;
        }
        
        else if(cloudType == 'both'){
            if(!syncPolicy && !policyName){
                toastr.info('Please select Sync & Backup Policies both', 'Information!!!', {allowHtml: true});
                return;
            }
        }

        if(userList.length > 0){
            blockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/migration/getUsers',
                data: {csrf_token: $('.csrf_token').html(), userList: $('#userNames').tagsinput('items'), policyName: policyName, syncPolicy: syncPolicy, migrationType: cloudType},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log(jData);
                $scope.currentGroupName = jData.groupName.groupName;
                if(jData.result == 'success'){
                    $scope.userList = jData.userList;
                    $('.migrationDetails').show();
                    $scope.$apply();
                }else{
                    if($scope.userList.length > 0){
                        $('.migrationDetails').hide();
                    }
                    toastr.error('Entered Users was not found', 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.info('Please enter the users list that has to be migrated', 'Information!!!', {allowHtml: true});
        }
    };

    $scope.changePolicy = function(policy, index){
        $('.selectedPolicySpan'+index).hide();
        $('.selectPolicyPicker'+index).show();
        $('.changePolicyBtn'+index).hide();
        $('.savePolicyBtn'+index).show();
        $('[name="selectedPolicy'+index+'"]').val(policy);
    };

    $scope.savePolicy = function(index){
        $('.selectedPolicySpan'+index).show();
        $('.selectPolicyPicker'+index).hide();
        $('.changePolicyBtn'+index).show();
        $('.savePolicyBtn'+index).hide();
        $scope.userList[index].defaultPolicy = $('[name="selectedPolicy'+index+'"]').val();
    };

    $scope.removeRow = function(index){
        $('.selectedPolicySpan'+index).show();
        $('.selectPolicyPicker'+index).hide();
        $('.changePolicyBtn'+index).show();
        $('.savePolicyBtn'+index).hide();
        $scope.userList.splice(index, 1);
        toastr.success('Selected user has been removed from the migrations list', 'Information!!!', {allowHtml: true});
    };

    $scope.changeSyncPolicy = function(policy, index){
        $('.selectedSyncPolicySpan'+index).hide();
        $('.selectSyncPolicyPicker'+index).show();
        $('.changeSyncPolicyBtn'+index).hide();
        $('.saveSyncPolicyBtn'+index).show();
        $('[name="selectedSyncPolicy'+index+'"]').val(policy);
    };

    $scope.saveSyncPolicy = function(index){
        $('.selectedSyncPolicySpan'+index).show();
        $('.selectSyncPolicyPicker'+index).hide();
        $('.changeSyncPolicyBtn'+index).show();
        $('.saveSyncPolicyBtn'+index).hide();
        $scope.userList[index].defaultSyncPolicy = $('[name="selectedSyncPolicy'+index+'"]').val();
    };

    $scope.startMigrating = function(){
        var migrationType = $('input[name="migrationType"]:checked').val();
        if($scope.userList.length > 0){
            blockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/migration/migrateUsers',
                data: {csrf_token: $('.csrf_token').html(), userList: $scope.userList, migrationType: migrationType, groupName: $scope.currentGroupName},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/migration'
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('There was not users found that were selected fro migration', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.gotTo = function(location){
        window.location.href = $scope.BASE_FOLDER+location;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'migrationDashboard'){
            $scope.updateMigrationDetails();
        }
    });

    $scope.readUserNamesFromExcel = function(files) {

        angular.forEach(files, function(file, key) {

            if (file && !file.$error) {

                file.upload = Upload.upload({
                    url: $scope.BASE_FOLDER+'/readExcelFromUpload',
                    fields: {csrf_token: $('.csrf_token').html(), path: $scope.crumbString},
                    file: file
                });

                file.upload.then(function (response) {
                    $timeout(function () {
                        file.result = response.data;
                        if(response.data.result == 'success'){
                            if(response.data.userNames.length > 0){
                                response.data.userNames.forEach(function(value, key){
                                    if(value.length > 1 ){
                                        $('#userNames').tagsinput('add', value);
                                    }
                                });

                                toastr.success('Usernames has been imported from the excel, please click on "import" and continue with the migration proccess', 'Successfully!!!', {allowHtml: true});
                            }else{
                                toastr.error('There was no usernames column in the selected excel file', 'Fail!!!', {allowHtml: true});
                            }
                        }else{
                            toastr.error(file.name, response.data.msg, 'Fail!!!', {allowHtml: true});
                        }
                    });
                }, function (response) {
                    if (response.status > 0)
                        $scope.errorMsg = response.status + ': ' + response.data;
                });

                file.upload.progress(function (evt) {
                    file.progress = Math.min(100, parseInt(100.0 *
                        evt.loaded / evt.total));
                });

            }
        });
    };

}]);