<?php
namespace Models;

use Core\Model;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SyncPms extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Sync Policy Management Model Model was called', 'info');
    }

    /**
     * Below Method gets all schedules
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSchedules($headers){
        $url = $this->api->getUrl('getSchedules');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveCloudCredentials($headers, $data){
        $url = $this->api->getVersionUrl('saveCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function updateCloudCredentials($headers, $data, $identity){
        $url = $this->api->getVersionUrl('updateCloudCredentials', array('identity' => $identity));
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function removeCloudCredentials($headers){
        $url = $this->api->getUrl('removeCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function getCloudCredentials($headers){
        $url = $this->api->getVersionUrl('getCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFilters($headers){
        $url = $this->api->getUrl('getFilters');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllPolicies($headers){
        $url = $this->api->getUrl('getAllSyncPolices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getPgs($headers){
        $url = $this->api->getUrl('getPgs');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all Policies
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function savePolicy($headers, $data){
        $url = $this->api->getUrl('saveSyncPolicy');
        $this->curl->setHeaders($headers);

        $this->log('Url: '.$url, 'info');
        $this->log('Headers: '.json_encode($headers), 'info');
        $this->log('Data: '.$data, 'info');

        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function editPolicy($headers, $data){
        $url = $this->api->getUrl('editSyncPolicy');
        $this->curl->setHeaders($headers);

        $this->log('Url: '.$url, 'info');
        $this->log('Headers: '.json_encode($headers), 'info');
        $this->log('Data: '.$data, 'info');

        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }


    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @param $policyName
     * @return array
     */
    public function getPolicy($headers, $policyName){
        $url = $this->api->getUrl('getSyncPolicy', array('policyName' => $policyName));
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function removeSyncPolicy($headers,$policyName){
        $url = $this->api->getUrl('removeSyncPolicy', array('policyName' => $policyName));
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getUserSyncPolicy($headers){
        $url = $this->api->getUrl('getUserSyncPolicy');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getPolicyMappingDetails($headers){
        $this->log('Post Data: '. json_encode($headers),'info');
        $url = $this->api->getUrl('policySyncMappingDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function searchPolicyMapping($headers){
        $url = $this->api->getUrl('searchSyncPolicyMapping');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveSinglePolicyMapping($headers, $data){
        $url = $this->api->getUrl('saveSingleSyncPolicyMapping');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Save Policy for a User
     *
     * @param $headers
     * @return array
     */
    public function saveMultiplePolicyMapping($headers){
        $url = $this->api->getUrl('saveMultipleSyncPolicyMapping');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Url: '. $url, 'info');
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

}
