<?php
namespace Models;

use Core\Model;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Settings extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Settings Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveEncryption($headers,$data){
        $url = $this->api->getVersionUrl('saveEncryption');
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function getEncryption($headers){
        $url = $this->api->getVersionUrl('getEncryption');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveLocalStorageDetails($headers, $data){
        $url = $this->api->getUrl('saveLocalStorageDetails');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveCloudCredentials($headers, $data){
        $url = $this->api->getVersionUrl('saveCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function updateCloudCredentials($headers, $data, $identity){
        $url = $this->api->getVersionUrl('updateCloudCredentials', array('identity' => $identity));
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeCloudCredentials($headers){
        $url = $this->api->getUrl('removeCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudCredentials($headers){
        $url = $this->api->getVersionUrl('getCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $data
     * @return array
     */
    public function saveAdCredentials($headers, $data){
        $url = $this->api->getUrl('saveAdCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    
    public function editAdCredentials($headers, $data){
        $url = $this->api->getUrl('editAdCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function removeAdCredentials($headers){
        $url = $this->api->getUrl('removeAdCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveSmtp($headers, $smtpDetails){
        $url = $this->api->getUrl('saveSmtp');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $smtpDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSmtp($headers){
        $url = $this->api->getUrl('getSmtp');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $cloudDetails
     * @return array
     */
    public function saveCloudProperties($headers, $cloudDetails){
        $url = $this->api->getVersionUrl('saveCloudProperties');
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $cloudDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getCloudProperties($headers){
        $url = $this->api->getVersionUrl('getCloudProperties');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAdCredentials($headers){
        $url = $this->api->getUrl('getAdCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAdCredential($headers){
        $url = $this->api->getUrl('getAdCredential');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getLocalStorageDetails($headers){
        $url = $this->api->getUrl('getLocalStorageDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getProxyDetails($headers){
        $url = $this->api->getVersionUrl('getProxyDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    public function removeProxyDetails($headers,$proxyHost){
        $url = $this->api->getVersionUrl('removeProxyDetails', array('proxyHost' => $proxyHost));
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveProxyDetails($headers,$data){
        $url = $this->api->getVersionUrl('saveProxyDetails');
        $this->curl->setHeaders($headers);
        $this->curl->post($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    
    public function editProxyDetails($headers,$data,$proxyHost){
        $url = $this->api->getVersionUrl('editProxyDetails', array('proxyHost' => $proxyHost));
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $odbDetails
     * @return array
     */
    public function saveOdbDetails($headers, $odbDetails){
        $url = $this->api->getUrl('saveOdbDetails');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $odbDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $googleDetails
     * @return array
     */
    public function saveGoogleDetails($headers, $googleDetails){
        $url = $this->api->getUrl('saveOdbDetails');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $googleDetails);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */


    public function getOdbDetails($headers){
        $url = $this->api->getUrl('getOdbDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

}
