<?php
namespace Models;

use Core\Model;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Report extends Model{

    public function __construct(){
        parent::__construct();
        $this->log('Report Model was called', 'info');
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStatistics($headers){
        $url = $this->api->getUrl('getStatistics');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getServerBackupStatistics($headers){
        $url = $this->api->getUrl('getServerBackupStatistics');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getOverview($headers){
        $url = $this->api->getUrl('getOverviewNew');
        $this->log("usrl". $url, "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getSyncCLoudUsage($headers){
        $url = $this->api->getUrl('syncCLoudUsage');
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getOverviewAll($headers){
        $url = $this->api->getUrl('getOverviewAll');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getRestoreHistory($headers){
        $url = $this->api->getUrl('getRestoreHistory');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function updateSyncCloudUsageDetails($headers){
        $url = $this->api->getUrl('updateSyncCloudUsageDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getLongBackupDetails($headers){
        $url = $this->api->getUrl('longBackup');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getCurrentBackupDetails($headers){
        $url = $this->api->getUrl('currentBackup');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getNoBackupDetails($headers){
        $url = $this->api->getUrl('noBackup');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStorageUtilized($headers){
        $url = $this->api->getUrl('storageUtilized');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getStorageUtilizedByPG($headers){
        $url = $this->api->getUrl('storageUtilizedByPG');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getFailedBackup($headers){
        $url = $this->api->getUrl('failedBackup');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getStorageTrend($startDate, $toDate){
        $url = $this->api->getUrl('storageTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getBlobTrend($startDate, $toDate){
        $url = $this->api->getUrl('blobTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $startDate
     * @param $toDate
     * @return array
     */
    function getBackupTrend($startDate, $toDate){
        $url = $this->api->getUrl('backupTrend');
        $headers[] 	= 'Content-Type: application/json';
        $headers[] 	= 'startDate: '.$startDate;
        $headers[] 	= 'endDate: '.$toDate;
        $ch 		= curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $result 		= curl_exec($ch);
        $intReturnCode 	= curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $this->log('statusCode : '. $intReturnCode, 'info');
        if($intReturnCode == 200 ) {
            return $result;
        }
        else{
            return null;
        }
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserDeviceHistory($headers){
        $url = $this->api->getUrl('userDeviceHistory');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserBackupHistory($headers){
        $url = $this->api->getUrl('userBackupHistory');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDailyUserBackupOverview($headers){
        $url = $this->api->getUrl('dailyUserBackupOverview');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadDailyUserBackupOverview($headers){
        $url = $this->api->getUrl('downloadDailyUserBackupOverview');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDeviceBackupHistory($headers){
        $url = $this->api->getUrl('deviceBackup');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getDeviceUserHistory($headers){
        $url = $this->api->getUrl('deviceUserHistory');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getLastBackupDetails($headers){
        $url = $this->api->getUrl('lastBackupDetails');
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getAlertHistory($headers){
        $url = $this->api->getUrl('alertHistory');
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function getUserMigration($headers){
        $url = $this->api->getUrl('userMigration');
        $this->log('Headers: '. json_encode($headers), 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadOverViewReport($headers){
        $url = $this->api->getUrl('overviewReport');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadSyncOverViewReport($headers){
        $url = $this->api->getUrl('syncOverviewReportDownload');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Get Report Statistics
     *
     * @param $headers
     * @return array
     */
    public function downloadOverViewReportSync($headers){
        $url = $this->api->getUrl('overViewReportSync');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

}