<?php
namespace Models;

use Core\Model;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Device extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('Device Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDevicePolicyInfo($headers){
        $url = $this->api->getUrl('userDevicePolicyInfo');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addInclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addInclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeInclusionFolder($headers){
        $url = $this->api->getUrl('removeInclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addExclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addExclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeExclusionFolder($headers){
        $url = $this->api->getUrl('removeExclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllDevices($headers){
        $url = $this->api->getUrl('listOfDevices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function searchInDevices($headers){
        $url = $this->api->getUrl('searchDevices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $device
     * @param $userName
     * @return array
     */
    public function blockUnBlockDevice($headers, $userName, $device){
        $this->log('XMl Data:' . $device, 'info');
        $url = $this->api->getUrl('blockUnBlockDevice', array('userName' => $userName));
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $device);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    public function blockDevices($headers, $data){
        $url = $this->api->getParacloudUrl('blockDevices');
        $this->curl->setHeaders($headers);
        $this->log('URL: '. $url, 'info');
        $this->log('DATA: '. $data, 'info');
        $this->curl->post($url, $data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Resultfffff: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $device
     * @param $userName
     * @return array
     */
    public function deleteDevice($headers, $userName, $device){
        $this->log('XMl Data:' . $device, 'info');
        $url = $this->api->getUrl('deleteDevice', array('userName' => $userName));
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $device);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function blockUnBlockMultipleDevice($headers, $data){
        $url = $this->api->getParacloudUrl('blockUnBlockDevices');
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all devices from a user
     *
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $userName
     * @return array
     */
    public function deleteMultipleDevices($headers, $data){
        $url = $this->api->getParacloudUrl('deleteDevices');
        $this->curl->setHeaders($headers);
        $this->curl->put($url,$data);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result'.json_encode($result), 'info');
        return $result;
    }

}
