<?php
namespace Core;

use Core\Error;
use Helpers\Session;

/*
 * Language - simple language handler
 *
 * @author Bartek Kuśmierczuk - contact@qsma.pl - http://qsma.pl
 * @version 2.2
 * @date November 18, 2014
 * @date updated May 18 2015
 */
class Language
{
    /**
     * Variable holds array with language
     * @var array
     */
    private $array;

    /**
     * Holds a session object to retrieve session info
     * @var
     */
    private $session;

    /**
     * Creates a session object to use
     */
    public function __construct(){
        if(empty($this->session)){
            $this->session = new Session();
        }
    }

    /**
     * Load language function
     * @param  string $name
     * @param  string $code
     */
    public function load($name, $code = ''){

        if(!empty($code)){
            $language = $code;
        }elseif(!empty($this->session->get('language'))){
            $language = $this->session->get('language');
        }else{
            $this->session->put('language', LANGUAGE_CODE);
            $language = $this->session->get('language');
        }

        $file = "app/language/$language/$name.php";

        if (is_readable($file)) {
            $this->array = include($file);
        } else {
            // display error
            // echo Error::display("Could not load language file '$code/$name.php'");
            // die;
        }
    }

    /**
     * Get element from language array by key
     * @param  string $value
     * @return string
     */
    public function get($value)
    {
        if (!empty($this->array[$value])) {
            return $this->array[$value];
        } else {
            return $value;
        }
    }

    /**
     * Get lang for views
     * @param  string $value this is "word" value from language file
     * @param  string $name  name of file with language
     * @param  string $code  optional, language code
     * @return string
     */
    public static function show($value, $name, $code = LANGUAGE_CODE)
    {
        // lang file
        $file = "app/language/$code/$name.php";

        // check if is readable
        if (is_readable($file)) {
            // require file
            $array = include($file);
        } else {
            // display error
            echo Error::display("Could not load language file '$code/$name.php'");
            die;
        }

        // If
        if (!empty($array[$value])) {
            return $array[$value];
        } else {
            return $value;
        }
    }
}
