<?php

namespace Controllers;
require_once(DIRECTORY_PATH.'/Helpers/Paraview/Classes/PHPExcel/IOFactory.php');
use Core\View;
use Models\Backup;
use PHPExcel_IOFactory;
use Core\Controller;
use Helpers\Url;
use Helpers\Auth;
use Helpers\Paraview\docReader;
use Helpers\Paraview\docxReader;
use Helpers\Paraview\odtReader;
use Helpers\Paraview\XMLExtractor;
use Models\ParaView;
use Models\Sync;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * ParaView controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com (Please do not remove this author thing, i worte man, :)
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ParaViewController extends Controller{

    /**
     * Below variable contains the object reference of a model
     * @version 1.0
     * @var object
     */

    protected $_model;

    /**
     * The below variable holds the data of the base path the file location
     * @version 1.0
     * @var string
     */
    var $filePath = PARAVIEW_TMP_PATH;

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedExtensions = array('pdf', 'docx', 'odt', 'txt', 'xls','xlsx', 'ods');

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedImageExtensions = array('png', 'jpg', 'jpeg', 'gif');

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedVideoExtensions = array('mp4', 'avi', 'webm', 'ogg');

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        if(SHARE_LOGIN_CHECK) {
            $this->auth->loginCheck();
        }
        $this->auth->tokenCheck();
        $this->language->load('index');
        $this->_model = new ParaView();
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function reader(){
        if(!empty($_POST['fileName']) && !empty($_POST['path'])) {
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token' => $this->session->get('token'),
                'path' => $_POST['path'].$_POST['fileName']
            );

            $sync = new Sync();
            $result = $sync->getFileInfo($headers);

            switch ($result['status']) {
                case (200):

                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = $this->filePath;
                    $this->cleanUpTempDirectory($fullPath);

                    $headers['file-name'] = (string)$result['body']->{'file-name'};
                    $headers['file-path'] = rtrim($_POST['path'], '/');
                    $headers['userName'] = $this->session->get('userName');
                    $headers['syncRevisionId'] = (string)$result['body']->{'file-revision-id'};
                    $headers['blukryptIp'] = $_POST['blukryptIp'];

                    $fileContent = $sync->download($headers);

                    if($fileContent['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
                            'msg' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                        ));
                        exit;
                    }

                    $fileFullPath   = $fullPath.ltrim($result['body']->{'file-name'}, DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $fileContent['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);

                    if(in_array($extension, $this->allowedImageExtensions)) {

                        $this->sendImageData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                        $this->sendVideoData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedExtensions)) {

                        if(method_exists($this, $extension)){

                            $this->$extension();

                        }else{
                            $data = array(
                                'result' => 'fail',
                                'msg' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                            );
                            $jsonDoc = json_encode($data);
                            echo $jsonDoc;
                            exit;
                        }
                    }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file format is not supported'
                        );
                        $jsonDoc = json_encode($data);
                        echo $jsonDoc;
                        exit;
                    }
                    break;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'No file was passed to view'
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function backupReader(){
        if(!empty($_POST['fileName']) && !empty($_POST['filePath'])) {
            $backup = new Backup();
            $result['status'] = 200;
            switch ($result['status']) {
                case (200):

                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = $this->filePath;
                    $this->cleanUpTempDirectory($fullPath);

                    $file['fileName'] = $_POST['fileName'];
                    $file['filePath'] = rtrim($_POST['filePath'], '/');
                    $file['userName'] = $_POST['userName'];
                    $file['backupID'] = $_POST['backupId'];
                    $file['deviceUUID'] = "";
                    $file['isSync'] = $_POST['isSync'];
                    $file['cloudName'] = $this->session->get("cloudName");

                    $fileContent = $backup->download($file);

                    if($fileContent['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
                            'msg' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                        ));
                        exit;
                    }

                    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $fileContent['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);

                    if(in_array($extension, $this->allowedImageExtensions)) {

                        $this->sendImageData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                        $this->sendVideoData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedExtensions)) {

                        if(method_exists($this, $extension)){

                            $this->$extension();

                        }else{
                            $data = array(
                                'result' => 'fail',
                                'msg' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                            );
                            $jsonDoc = json_encode($data);
                            echo $jsonDoc;
                            exit;
                        }
                    }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file format is not supported'
                        );
                        $jsonDoc = json_encode($data);
                        echo $jsonDoc;
                        exit;
                    }
                    break;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'No file was passed to view'
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function sharedFileReader(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['syncRevisionId'])){
            $_POST['fileName'] = urldecode($_POST['fileName']);

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;

            if($this->session->get('passwordProtected') == true && $checkForShareWith == false){
                if(!empty($_POST['password'])){
                    if($this->session->get('passwordHash') != md5($_POST['password'])){
                        echo json_encode(array(
                            'result' => 'fail',
                            'message' => 'Password Authentication Failed'
                        ));
                        exit;
                    }
                }else{
                    echo json_encode(array(
                        'result' => 'fail',
                        'message' => 'Password Authentication Failed'
                    ));
                    exit;
                }
            }
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $headers['file-name'] = $_POST['fileName'];
            $headers['file-path'] = rtrim($_POST['path'], '/');
            $headers['userName'] = $_POST['userName'];
            $headers['syncRevisionId'] = $_POST['syncRevisionId'];
            $sync = new Sync();
            $fileContent = $sync->download($headers);

            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }

            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);

            if(in_array($extension, $this->allowedImageExtensions)) {

                $this->sendImageData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                $this->sendVideoData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedExtensions)) {

                if(method_exists($this, $extension)){

                    $this->$extension();

                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }

        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function sharedBackupFileReader(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['backupID'])){
            $_POST['fileName'] = urldecode($_POST['fileName']);

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;

            if($this->session->get('passwordProtected') == true && $checkForShareWith == false){
                if(!empty($_POST['password'])){
                    if($this->session->get('passwordHash') != md5($_POST['password'])){
                        echo json_encode(array(
                            'result' => 'fail',
                            'message' => 'Password Authentication Failed'
                        ));
                        exit;
                    }
                }else{
                    echo json_encode(array(
                        'result' => 'fail',
                        'message' => 'Password Authentication Failed'
                    ));
                    exit;
                }
            }
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $file['fileName'] = $_POST['fileName'];
            $file['filePath'] = rtrim($_POST['path'], '/');
            $file['userName'] = $_POST['userName'];
            $file['backupID'] = $_POST['backupID'];
            $file['deviceUUID'] = "";
            $file['isSync'] = $_POST['isSync'];
            $file['cloudName'] = $this->session->get("cloudName");
            $backup = new Backup();
            $fileContent = $backup->download($file);

            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }

            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);

            if(in_array($extension, $this->allowedImageExtensions)) {

                $this->sendImageData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                $this->sendVideoData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedExtensions)) {

                if(method_exists($this, $extension)){

                    $this->$extension();

                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }

        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will paraview only docx formats
     */
    public function docx(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $extract = new DocxReader();
                $extract->docxPath = $this->filePath.$_POST['fileName'];
                $extract->content_folder = 'temp';
                $extract->image_max_width = '10000';
                $extract->imagePathPrefix = Url::basePath('');
                $extract->keepOriginalImage = true;
                $extract->Init();
                $doc = str_replace('<p>Â&nbsp;</p>', ' ', $extract->output);
                $jsonDoc = json_encode($doc);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /**
     * Below function will paraview only odt formats
     */
    public function odt(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $extract = new OdtReader();
                $extract->odtPath = $this->filePath . $_POST['fileName'];
                $extract->content_folder = 'temp';
                $extract->image_max_width = '10000';
                $extract->imagePathPrefix = '';
                $extract->keepOriginalImage = true;
                $extract->Init();
                $doc = str_replace('<p>Â&nbsp;</p>', ' ', $extract->output);
                $doc['type'] = 'odt';
                $jsonDoc = json_encode($doc);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /**
     * Below function will read only pdf formats
     * #toolbar=0 Add this to iframe url after file url to disable toolbar for pdf viewer
     */
    public function pdf(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $data = array(
                    'html' => '<iframe seamless="" style="margin-top: -50px;" width="100%" height="600" src="'.Url::basePath('pdfViewer?').'file=app/templates/default/documents/'.$_POST['fileName'].'"></iframe>',
                    'type' => 'pdf'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function pdfViewer(){
        View::render('paraview/pdf');
    }

    /**
     * below function excepts $filename a parameter
     * generates a link to view that file
     * @param $fileName
     */
    public function sendImageData($fileName){
        if(!empty($fileName)) {
            if(file_exists($this->filePath . $fileName)) {
                $data = array(
                    'html' => '<img style="max-height: 500px" src="'.Url::templatePath('default/documents/'.$_POST['fileName']).'">',
                    'type' => 'image'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /**
     * below function excepts $filename a parameter
     * generates a link to view that video file
     * @param $fileName
     */
    public function sendVideoData($fileName){
        if(!empty($fileName)) {
            if(file_exists($this->filePath . $fileName)) {
                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                $mimeType = finfo_file($finfo, $this->filePath . $fileName);
                finfo_close($finfo);
                $data = '<video height="500" controls>';
                $data .= '<source src="'.Url::templatePath('default/documents/'.$_POST['fileName']).'" type="'.$mimeType.'">';
                $data .= "I'm sorry; your browser doesn't support HTML5 video in WebM with VP8 or MP4 with H.264.";
                $data .= '</video>';
                $data = array(
                    'html' => $data,
                    'type' => 'image'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function xls(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$_POST['fileName']);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                $rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $htmlData = '<table id="customers">';
            foreach($pageData as $rowData){
                $htmlData .= '<tr>';
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $htmlData .= '<td style="'.$this->convertArrayToStylesString($rowData['styles']).'">' . $value . '</td>';
                    }
                }else{

                    $htmlData .= '<td></td>';
                }
                $htmlData .= '</tr>';
            }
            $htmlData .= '</table><br/>';
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'html' => $htmlData
            );

        }
        $data = array(
            'type' => 'excel',
            'html' => array_values($html)
        );
        echo json_encode($data);
    }

    public function xlsx(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$_POST['fileName']);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                $rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'

                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $htmlData = '<table id="customers">';
            foreach($pageData as $rowData){
                $htmlData .= '<tr>';
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $htmlData .= '<td style="'.$this->convertArrayToStylesString($rowData['styles']).'">' . $value . '</td>';
                    }
                }else{

                    $htmlData .= '<td></td>';
                }
                $htmlData .= '</tr>';
            }
            $htmlData .= '</table><br/>';
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'html' => $htmlData
            );

        }
        $data = array(
            'type' => 'excel',
            'html' => array_values($html)
        );
        echo json_encode($data);
    }

    public function ods(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$_POST['fileName']);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                $rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'

                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $htmlData = '<table id="customers">';
            foreach($pageData as $rowData){
                $htmlData .= '<tr>';
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $htmlData .= '<td style="'.$this->convertArrayToStylesString($rowData['styles']).'">' . $value . '</td>';
                    }
                }else{
                    $htmlData .= '<td></td>';
                }
                $htmlData .= '</tr>';
            }
            $htmlData .= '</table><br/>';
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'html' => $htmlData
            );

        }
        $data = array(
            'type' => 'excel',
            'html' => array_values($html)
        );
        echo json_encode($data);
    }

    public function convertArrayToStylesString($style){
        $string = '';
        if(is_array($style)){
            foreach($style as $key => $value){
                $string .= $key . ': ' . $value . ';';
            }
            return $string;
        }else{
            return '';
        }

    }

    public function txt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'html' => file_get_contents($this->filePath.$fileName),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }

    public function doc(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'html' => nl2br(file_get_contents($this->filePath.$fileName)),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function cleanUpTempDirectory($fullPath){
        $files = glob($fullPath.DS.'{,.}*', GLOB_BRACE);
        foreach($files as $file){
            if(is_file($file)){
                unlink($file);
            }
        }
    }

    public function readFileFromUpload($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $test = array();
        $rowData = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
            $highestRow1 = $sheet1->getHighestRow();
            $row1 = $objPHPExcel->getActiveSheet()->getCell(A2)->getRow();
            $this->log('Result_row1: '.json_encode($row1), 'info');
            $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
            $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        
        
        $this->log('Result_Test11: '.json_encode($test), 'info');
        $this->log('Result_PagewiseData: '.json_encode($pageWiseData), 'info');
        $this->log('Result_PagewiseData0000: '.json_encode($pageWiseData[0]), 'info');
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            //$this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            //$this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];  
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    //$this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'userNames' => $htmlData
            );
        }
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html)
        );//$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }

    public function readFileFromUploadForDevices($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
            $highestRow1 = $sheet1->getHighestRow();
            $row1 = $objPHPExcel->getActiveSheet()->getCell(A2)->getRow();
            $this->log('Result_row1: '.json_encode($row1), 'info');
            $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
            $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                array_push($data, $rowData);
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');
                
            }
            array_push($pageWiseData, $data);
        }
        
        
        
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
            $even = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');
        
        foreach($pageWiseData as $pageKey => $pageData){
        foreach($pageData as $rowDatar){
                if(!empty($rowDatar[0])) {
                foreach( $rowDatar[0] as $key => $value ) {
                    if( 0 === $key%2) { //Even
                        $even[]['userName'] = $value;
                        //$even[] = array('userName' => $value);
                        //$this->log('Result_dataEVEN: '.json_encode($even), 'info');
                    }
                    else {
                        $odd[]['deviceName'] = $value;
                        //$odd[] = array('deviceName' => $value);
                    }
                }}
            }
            
        }
        for($i=1;$i<sizeof($even)-1;$i++){
            
            $dog[] = array_merge($even[$i],$odd[$i]);
        }
        $this->log('Result_datacgARRAYFILL: '.json_encode($even),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($odd),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($dog),'info');
        function combineStringArrayWithDuplicates ($even, $odd) {
                $iter = 0; 
                foreach ($even as $key) 
                    { 
                        $combined[$iter] = $key .": ". $odd[$iter];
                        $iter++;
                        
                    }
                    return $combined;
              }

                $combined = combineStringArrayWithDuplicates($even, $odd);


                $this->log('Result_datacgjjjjjjjjjjjjjjjj: '.json_encode($combined), 'info');
                //$new = array('deviceList' => $combined);
                $new = array('deviceList' => $dog);
        
        
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];
            
            
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }
            
            
                
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'userNames' => $htmlData
            );
        }
        
        
        
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'deviceList' => $new
        );$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }

}
