/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ohai.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.chef.util.ChefUtils;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;
import org.jclouds.ohai.Automatic;
import org.jclouds.ohai.AutomaticSupplier;
import org.jclouds.ohai.config.ConfiguresOhai;
import org.jclouds.ohai.functions.ByteArrayToMacAddress;
import org.jclouds.ohai.functions.MapSetToMultimap;

@ConfiguresOhai
public class OhaiModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<byte[], String>>(){}).to((TypeLiteral)new TypeLiteral<ByteArrayToMacAddress>(){});
        this.bindOhai();
    }

    @Provides
    @Automatic
    protected Supplier<Map<String, JsonBall>> provideAutomatic(AutomaticSupplier in) {
        return in;
    }

    @Provides
    @Automatic
    Multimap<String, Supplier<JsonBall>> provideAutomatic(MapSetToMultimap<String, Supplier<JsonBall>> converter, @Automatic Map<String, Set<Supplier<JsonBall>>> input) {
        return converter.apply(input);
    }

    @Named(value="systemProperties")
    @Provides
    protected Properties systemProperties() {
        return System.getProperties();
    }

    public MapBinder<String, Supplier<JsonBall>> bindOhai() {
        MapBinder mapbinder = ChefUtils.ohaiAutomaticAttributeBinder(this.binder()).permitDuplicates();
        mapbinder.addBinding((Object)"ohai_time").to(OhaiTimeProvider.class);
        mapbinder.addBinding((Object)"jvm/system").to(SystemPropertiesProvider.class);
        mapbinder.addBinding((Object)"platform").to(PlatformProvider.class);
        mapbinder.addBinding((Object)"platform_version").to(PlatformVersionProvider.class);
        mapbinder.addBinding((Object)"current_user").to(CurrentUserProvider.class);
        return mapbinder;
    }

    @Provides
    protected Long millis() {
        return System.currentTimeMillis();
    }

    public static class SystemPropertyProvider
    implements Supplier<JsonBall> {
        private final Properties systemProperties;
        private final String property;

        @Inject
        SystemPropertyProvider(String property, @Named(value="systemProperties") Properties systemProperties) {
            this.property = property;
            this.systemProperties = systemProperties;
        }

        public JsonBall get() {
            return this.systemProperties.containsKey(this.property) ? new JsonBall(this.systemProperties.getProperty(this.property)) : null;
        }
    }

    @Singleton
    public static class CurrentUserProvider
    extends SystemPropertyProvider {
        @Inject
        CurrentUserProvider(@Named(value="systemProperties") Properties systemProperties) {
            super("user.name", systemProperties);
        }
    }

    @Singleton
    public static class PlatformVersionProvider
    extends SystemPropertyProvider {
        @Inject
        PlatformVersionProvider(@Named(value="systemProperties") Properties systemProperties) {
            super("os.version", systemProperties);
        }
    }

    @Singleton
    public static class PlatformProvider
    extends SystemPropertyProvider {
        @Inject
        PlatformProvider(@Named(value="systemProperties") Properties systemProperties) {
            super("os.name", systemProperties);
        }

        @Override
        public JsonBall get() {
            JsonBall returnValue = super.get();
            return returnValue != null ? new JsonBall(returnValue.toString().replaceAll("[ -]", "").toLowerCase()) : null;
        }
    }

    @Singleton
    public static class SystemPropertiesProvider
    implements Supplier<JsonBall> {
        private final Json json;
        private final Properties systemProperties;

        @Inject
        SystemPropertiesProvider(Json json, @Named(value="systemProperties") Properties systemProperties) {
            this.json = json;
            this.systemProperties = systemProperties;
        }

        public JsonBall get() {
            return new JsonBall(this.json.toJson((Object)this.systemProperties));
        }
    }

    @Singleton
    public static class OhaiTimeProvider
    implements Supplier<JsonBall> {
        private final Provider<Long> timeProvider;

        @Inject
        OhaiTimeProvider(Provider<Long> timeProvider) {
            this.timeProvider = timeProvider;
        }

        public JsonBall get() {
            return ChefUtils.toOhaiTime((Long)this.timeProvider.get());
        }
    }
}

