/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.chef.domain.Attribute;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class Metadata {
    private final String license;
    private final String maintainer;
    private final Map<String, String> suggestions;
    private final Map<String, String> dependencies;
    @SerializedName(value="maintainer_email")
    private final String maintainerEmail;
    private final Map<String, String> conflicting;
    private final String description;
    private final Map<String, String> providing;
    private final Map<String, String> platforms;
    private final String version;
    private final Map<String, String> recipes;
    private final Map<String, String> replacing;
    private final String name;
    private final Map<String, String> groupings;
    @SerializedName(value="long_description")
    private final String longDescription;
    private final Map<String, Attribute> attributes;
    private final Map<String, String> recommendations;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"license", "maintainer", "suggestions", "dependencies", "maintainer_email", "conflicting", "description", "providing", "platforms", "version", "recipes", "replacing", "name", "groupings", "long_description", "attributes", "recommendations"})
    protected Metadata(String license, String maintainer, @Nullable Map<String, String> suggestions, @Nullable Map<String, String> dependencies, String maintainerEmail, @Nullable Map<String, String> conflicting, String description, @Nullable Map<String, String> providing, @Nullable Map<String, String> platforms, String version, @Nullable Map<String, String> recipes, @Nullable Map<String, String> replacing, String name, @Nullable Map<String, String> groupings, String longDescription, @Nullable Map<String, Attribute> attributes, @Nullable Map<String, String> recommendations) {
        this.license = license;
        this.maintainer = maintainer;
        this.suggestions = CollectionUtils.copyOfOrEmpty(suggestions);
        this.dependencies = CollectionUtils.copyOfOrEmpty(dependencies);
        this.maintainerEmail = maintainerEmail;
        this.conflicting = CollectionUtils.copyOfOrEmpty(conflicting);
        this.description = description;
        this.providing = CollectionUtils.copyOfOrEmpty(providing);
        this.platforms = CollectionUtils.copyOfOrEmpty(platforms);
        this.version = version;
        this.recipes = CollectionUtils.copyOfOrEmpty(recipes);
        this.replacing = CollectionUtils.copyOfOrEmpty(replacing);
        this.name = name;
        this.groupings = CollectionUtils.copyOfOrEmpty(groupings);
        this.longDescription = longDescription;
        this.attributes = CollectionUtils.copyOfOrEmpty(attributes);
        this.recommendations = CollectionUtils.copyOfOrEmpty(recommendations);
    }

    public String getLicense() {
        return this.license;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public Map<String, String> getSuggestions() {
        return this.suggestions;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public String getMaintainerEmail() {
        return this.maintainerEmail;
    }

    public Map<String, String> getConflicting() {
        return this.conflicting;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProviding() {
        return this.providing;
    }

    public Map<String, String> getPlatforms() {
        return this.platforms;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getRecipes() {
        return this.recipes;
    }

    public Map<String, String> getReplacing() {
        return this.replacing;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getGroupings() {
        return this.groupings;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getRecommendations() {
        return this.recommendations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.conflicting == null ? 0 : this.conflicting.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.groupings == null ? 0 : this.groupings.hashCode());
        result = 31 * result + (this.license == null ? 0 : this.license.hashCode());
        result = 31 * result + (this.longDescription == null ? 0 : this.longDescription.hashCode());
        result = 31 * result + (this.maintainer == null ? 0 : this.maintainer.hashCode());
        result = 31 * result + (this.maintainerEmail == null ? 0 : this.maintainerEmail.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platforms == null ? 0 : this.platforms.hashCode());
        result = 31 * result + (this.providing == null ? 0 : this.providing.hashCode());
        result = 31 * result + (this.recipes == null ? 0 : this.recipes.hashCode());
        result = 31 * result + (this.recommendations == null ? 0 : this.recommendations.hashCode());
        result = 31 * result + (this.replacing == null ? 0 : this.replacing.hashCode());
        result = 31 * result + (this.suggestions == null ? 0 : this.suggestions.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata other = (Metadata)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.conflicting == null ? other.conflicting != null : !this.conflicting.equals(other.conflicting)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.groupings == null ? other.groupings != null : !this.groupings.equals(other.groupings)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals(other.license)) {
            return false;
        }
        if (this.longDescription == null ? other.longDescription != null : !this.longDescription.equals(other.longDescription)) {
            return false;
        }
        if (this.maintainer == null ? other.maintainer != null : !this.maintainer.equals(other.maintainer)) {
            return false;
        }
        if (this.maintainerEmail == null ? other.maintainerEmail != null : !this.maintainerEmail.equals(other.maintainerEmail)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.platforms == null ? other.platforms != null : !this.platforms.equals(other.platforms)) {
            return false;
        }
        if (this.providing == null ? other.providing != null : !this.providing.equals(other.providing)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !this.recipes.equals(other.recipes)) {
            return false;
        }
        if (this.recommendations == null ? other.recommendations != null : !this.recommendations.equals(other.recommendations)) {
            return false;
        }
        if (this.replacing == null ? other.replacing != null : !this.replacing.equals(other.replacing)) {
            return false;
        }
        if (this.suggestions == null ? other.suggestions != null : !this.suggestions.equals(other.suggestions)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "Metadata [attributes=" + this.attributes + ", conflicting=" + this.conflicting + ", dependencies=" + this.dependencies + ", description=" + this.description + ", groupings=" + this.groupings + ", license=" + this.license + ", longDescription=" + this.longDescription + ", maintainer=" + this.maintainer + ", maintainerEmail=" + this.maintainerEmail + ", name=" + this.name + ", platforms=" + this.platforms + ", providing=" + this.providing + ", recipes=" + this.recipes + ", recommendations=" + this.recommendations + ", replacing=" + this.replacing + ", suggestions=" + this.suggestions + ", version=" + this.version + "]";
    }

    public static class Builder {
        private String license;
        private String maintainer;
        private ImmutableMap.Builder<String, String> suggestions = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> dependencies = ImmutableMap.builder();
        private String maintainerEmail;
        private ImmutableMap.Builder<String, String> conflicting = ImmutableMap.builder();
        private String description;
        private ImmutableMap.Builder<String, String> providing = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> platforms = ImmutableMap.builder();
        private String version;
        private ImmutableMap.Builder<String, String> recipes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> replacing = ImmutableMap.builder();
        private String name;
        private ImmutableMap.Builder<String, String> groupings = ImmutableMap.builder();
        private String longDescription;
        private ImmutableMap.Builder<String, Attribute> attributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> recommendations = ImmutableMap.builder();

        public Builder license(String license) {
            this.license = (String)Preconditions.checkNotNull((Object)license, (Object)"license");
            return this;
        }

        public Builder maintainer(String maintainer) {
            this.maintainer = (String)Preconditions.checkNotNull((Object)maintainer, (Object)"maintainer");
            return this;
        }

        public Builder suggestion(String key, String value) {
            this.suggestions.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder suggestions(Map<String, String> suggestions) {
            this.suggestions.putAll((Map)Preconditions.checkNotNull(suggestions, (Object)"suggestions"));
            return this;
        }

        public Builder dependency(String key, String value) {
            this.dependencies.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder dependencies(Map<String, String> dependencies) {
            this.dependencies.putAll((Map)Preconditions.checkNotNull(dependencies, (Object)"dependencies"));
            return this;
        }

        public Builder maintainerEmail(String maintainerEmail) {
            this.maintainerEmail = (String)Preconditions.checkNotNull((Object)maintainerEmail, (Object)"maintainerEmail");
            return this;
        }

        public Builder conflicting(String key, String value) {
            this.conflicting.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder conflicting(Map<String, String> conflicting) {
            this.conflicting.putAll((Map)Preconditions.checkNotNull(conflicting, (Object)"conflicting"));
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        public Builder providing(String key, String value) {
            this.providing.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder providing(Map<String, String> providing) {
            this.providing.putAll((Map)Preconditions.checkNotNull(providing, (Object)"providing"));
            return this;
        }

        public Builder platform(String key, String value) {
            this.platforms.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder platforms(Map<String, String> platforms) {
            this.platforms.putAll((Map)Preconditions.checkNotNull(platforms, (Object)"platforms"));
            return this;
        }

        public Builder version(String version) {
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            return this;
        }

        public Builder recipe(String key, String value) {
            this.recipes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder recipes(Map<String, String> recipes) {
            this.recipes.putAll((Map)Preconditions.checkNotNull(recipes, (Object)"recipes"));
            return this;
        }

        public Builder replacing(String key, String value) {
            this.replacing.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder replacing(Map<String, String> replacing) {
            this.replacing.putAll((Map)Preconditions.checkNotNull(replacing, (Object)"replacing"));
            return this;
        }

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder grouping(String key, String value) {
            this.groupings.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder grouping(Map<String, String> groupings) {
            this.groupings.putAll((Map)Preconditions.checkNotNull(groupings, (Object)"groupings"));
            return this;
        }

        public Builder longDescription(String longDescription) {
            this.longDescription = (String)Preconditions.checkNotNull((Object)longDescription, (Object)"longDescription");
            return this;
        }

        public Builder attribute(String key, Attribute value) {
            this.attributes.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder attributes(Map<String, Attribute> attributes) {
            this.attributes.putAll((Map)Preconditions.checkNotNull(attributes, (Object)"attributes"));
            return this;
        }

        public Builder recommendation(String key, String value) {
            this.recommendations.put(Preconditions.checkNotNull((Object)key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder recommendations(Map<String, String> recommendations) {
            this.recommendations.putAll((Map)Preconditions.checkNotNull(recommendations, (Object)"recommendations"));
            return this;
        }

        public Metadata build() {
            return new Metadata(this.license, this.maintainer, (Map<String, String>)this.suggestions.build(), (Map<String, String>)this.dependencies.build(), this.maintainerEmail, (Map<String, String>)this.conflicting.build(), this.description, (Map<String, String>)this.providing.build(), (Map<String, String>)this.platforms.build(), this.version, (Map<String, String>)this.recipes.build(), (Map<String, String>)this.replacing.build(), this.name, (Map<String, String>)this.groupings.build(), this.longDescription, (Map<String, Attribute>)this.attributes.build(), (Map<String, String>)this.recommendations.build());
        }
    }
}

