/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.ImplementedBy;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.config.CookbookParser;
import org.jclouds.chef.config.CookbookVersionsParser;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.functions.ParseCookbookDefinitionFromJson;
import org.jclouds.chef.functions.ParseCookbookVersionsV09FromJson;
import org.jclouds.chef.functions.ParseCookbookVersionsV10FromJson;
import org.jclouds.chef.functions.ParseKeySetFromJson;
import org.jclouds.chef.suppliers.ChefVersionSupplier;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;
import org.jclouds.json.internal.NullHackJsonLiteralAdapter;

public class ChefParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings(DataBagItemAdapter adapter, PrivateKeyAdapter privateAdapter, PublicKeyAdapter publicAdapter, X509CertificateAdapter certAdapter) {
        return ImmutableMap.of(DatabagItem.class, (Object)((Object)adapter), PrivateKey.class, (Object)privateAdapter, PublicKey.class, (Object)publicAdapter, X509Certificate.class, (Object)certAdapter);
    }

    @Provides
    @Singleton
    @CookbookParser
    public Function<HttpResponse, Set<String>> provideCookbookDefinitionAdapter(ChefVersionSupplier chefVersionSupplier, ParseCookbookDefinitionFromJson v10parser, ParseKeySetFromJson v09parser) {
        return chefVersionSupplier.get() >= 10 ? v10parser : v09parser;
    }

    @Provides
    @Singleton
    @CookbookVersionsParser
    public Function<HttpResponse, Set<String>> provideCookbookDefinitionAdapter(ChefVersionSupplier chefVersionSupplier, ParseCookbookVersionsV10FromJson v10parser, ParseCookbookVersionsV09FromJson v09parser) {
        return chefVersionSupplier.get() >= 10 ? v10parser : v09parser;
    }

    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind(NullFilteringTypeAdapterFactories.MapTypeAdapterFactory.class).to(KeepLastRepeatedKeyMapTypeAdapterFactory.class);
    }

    public static class KeepLastRepeatedKeyMapTypeAdapterFactory
    extends NullFilteringTypeAdapterFactories.MapTypeAdapterFactory {
        public KeepLastRepeatedKeyMapTypeAdapterFactory() {
            super(Map.class);
        }

        protected <K, V, T> TypeAdapter<T> newAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            return new KeepLastRepeatedKeyMapTypeAdapter<K, V>(keyAdapter, valueAdapter);
        }
    }

    private static final class KeepLastRepeatedKeyMapTypeAdapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        protected final TypeAdapter<K> keyAdapter;
        protected final TypeAdapter<V> valueAdapter;

        protected KeepLastRepeatedKeyMapTypeAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            this.keyAdapter = keyAdapter;
            this.valueAdapter = valueAdapter;
            this.nullSafe();
        }

        public void write(JsonWriter out, Map<K, V> value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            for (Map.Entry<K, V> element : value.entrySet()) {
                out.name(String.valueOf(element.getKey()));
                this.valueAdapter.write(out, element.getValue());
            }
            out.endObject();
        }

        public Map<K, V> read(JsonReader in) throws IOException {
            HashMap result = Maps.newHashMap();
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                Object name = this.keyAdapter.read(in);
                Object value = this.valueAdapter.read(in);
                if (value == null) continue;
                result.put(name, value);
            }
            in.endObject();
            return ImmutableMap.copyOf((Map)result);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.keyAdapter, this.valueAdapter});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            KeepLastRepeatedKeyMapTypeAdapter that = (KeepLastRepeatedKeyMapTypeAdapter)((Object)KeepLastRepeatedKeyMapTypeAdapter.class.cast(obj));
            return Objects.equal(this.keyAdapter, that.keyAdapter) && Objects.equal(this.valueAdapter, that.valueAdapter);
        }

        public String toString() {
            return Objects.toStringHelper((Object)((Object)this)).add("keyAdapter", this.keyAdapter).add("valueAdapter", this.valueAdapter).toString();
        }
    }

    private static class IdHolder {
        private String id;

        private IdHolder() {
        }
    }

    @Singleton
    public static class DataBagItemAdapter
    extends NullHackJsonLiteralAdapter<DatabagItem> {
        final Gson gson = new Gson();

        protected DatabagItem createJsonLiteralFromRawJson(String text) {
            IdHolder idHolder = (IdHolder)this.gson.fromJson(text, IdHolder.class);
            Preconditions.checkState((idHolder.id != null ? 1 : 0) != 0, (String)"databag item must be a json hash ex. {\"id\":\"item1\",\"my_key\":\"my_data\"}; was %s", (Object[])new Object[]{text});
            text = text.replaceFirst(String.format("\\{\"id\"[ ]?:\"%s\",", idHolder.id), "{");
            return new DatabagItem(idHolder.id, text);
        }

        protected String toString(DatabagItem value) {
            String text = value.toString();
            try {
                IdHolder idHolder = (IdHolder)this.gson.fromJson(text, IdHolder.class);
                if (idHolder.id == null) {
                    text = text.replaceFirst("\\{", String.format("{\"id\":\"%s\",", value.getId()));
                } else {
                    Preconditions.checkArgument((boolean)value.getId().equals(idHolder.id), (String)"incorrect id in databagItem text, should be %s: was %s", (Object[])new Object[]{value.getId(), idHolder.id});
                }
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            return text;
        }
    }

    @Singleton
    public static class X509CertificateAdapterImpl
    implements X509CertificateAdapter {
        private final Crypto crypto;

        @Inject
        X509CertificateAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        public X509Certificate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return Pems.x509Certificate((ByteSource)ByteSource.wrap((byte[])keyText.getBytes(Charsets.UTF_8)), (CertificateFactory)this.crypto.certFactory());
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (CertificateException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @ImplementedBy(value=X509CertificateAdapterImpl.class)
    public static interface X509CertificateAdapter
    extends JsonDeserializer<X509Certificate> {
    }

    @Singleton
    public static class PublicKeyAdapterImpl
    implements PublicKeyAdapter {
        private final Crypto crypto;

        @Inject
        PublicKeyAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        public PublicKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return this.crypto.rsaKeyFactory().generatePublic(Pems.publicKeySpec((ByteSource)ByteSource.wrap((byte[])keyText.getBytes(Charsets.UTF_8))));
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @ImplementedBy(value=PublicKeyAdapterImpl.class)
    public static interface PublicKeyAdapter
    extends JsonDeserializer<PublicKey> {
    }

    @Singleton
    public static class PrivateKeyAdapterImpl
    implements PrivateKeyAdapter {
        private final Crypto crypto;

        @Inject
        PrivateKeyAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        public PrivateKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return this.crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((ByteSource)ByteSource.wrap((byte[])keyText.getBytes(Charsets.UTF_8))));
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @ImplementedBy(value=PrivateKeyAdapterImpl.class)
    public static interface PrivateKeyAdapter
    extends JsonDeserializer<PrivateKey> {
    }
}

