/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

public class HeaderFieldName {
    private final String name;

    protected static String formatCanonical(String name) {
        String nameTrimmed = name.trim();
        if (nameTrimmed.isEmpty()) {
            throw new IllegalArgumentException("The header field name must not be an empty string");
        }
        if (!nameTrimmed.matches("^[a-zA-Z][\\w-]*$")) {
            throw new IllegalArgumentException("Invalid header field name syntax");
        }
        String[] tokens = nameTrimmed.toLowerCase().split("-");
        String out = "";
        for (int i = 0; i < tokens.length; ++i) {
            char[] c = tokens[i].toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            if (i >= 1) {
                out = out + "-";
            }
            out = out + new String(c);
        }
        return out;
    }

    public HeaderFieldName(String name) {
        this.name = HeaderFieldName.formatCanonical(name);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof HeaderFieldName && this.name.equals(object.toString());
    }
}

