/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccessRule;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.ConnectionThrottle;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.HealthMonitor;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.SessionPersistence;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.VirtualIP;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.internal.BaseLoadBalancer;

public class CreateLoadBalancer
extends BaseLoadBalancer<AddNode, CreateLoadBalancer> {
    private final Set<Map<String, String>> virtualIps;
    private final Set<AccessRule> accessRules;
    private final Map<String, String> metadata;

    public CreateLoadBalancer(String name, String protocol, @Nullable Integer port, Set<AddNode> addNodes, @Nullable BaseLoadBalancer.Algorithm algorithm, @Nullable Integer timeout, @Nullable Boolean halfClosed, @Nullable Map<String, SessionPersistence> sessionPersistenceType, @Nullable Map<String, Boolean> connectionLogging, @Nullable ConnectionThrottle connectionThrottle, @Nullable HealthMonitor healthMonitor, @Nullable Set<AccessRule> accessRules, @Nullable Map<String, String> metadata, VirtualIP.Type virtualIPType, Integer virtualIPId) {
        this(name, protocol, port, addNodes, algorithm, timeout, halfClosed, sessionPersistenceType, connectionLogging, connectionThrottle, healthMonitor, accessRules, metadata, CreateLoadBalancer.getVirtualIPsFromOptions(virtualIPType, virtualIPId));
    }

    public CreateLoadBalancer(String name, String protocol, @Nullable Integer port, Set<AddNode> addNodes, @Nullable BaseLoadBalancer.Algorithm algorithm, @Nullable Integer timeout, @Nullable Boolean halfClosed, @Nullable Map<String, SessionPersistence> sessionPersistenceType, @Nullable Map<String, Boolean> connectionLogging, @Nullable ConnectionThrottle connectionThrottle, @Nullable HealthMonitor healthMonitor, @Nullable Set<AccessRule> accessRules, @Nullable Map<String, String> metadata, Set<Map<String, String>> virtualIPsFromOptions) {
        super(name, protocol, port, addNodes, algorithm, timeout, halfClosed, sessionPersistenceType, connectionLogging, connectionThrottle, healthMonitor);
        this.virtualIps = (Set)Preconditions.checkNotNull(virtualIPsFromOptions, (Object)"virtualIPsFromOptions");
        this.accessRules = accessRules;
        this.metadata = metadata;
    }

    public Map<String, String> getMetadata() {
        return this.metadata != null ? this.metadata : ImmutableMap.of();
    }

    public Set<AccessRule> getAccessRules() {
        return this.accessRules != null ? this.accessRules : ImmutableSet.of();
    }

    static Set<Map<String, String>> getVirtualIPsFromOptions(VirtualIP.Type virtualIPType, Integer virtualIPId) {
        Preconditions.checkArgument((virtualIPType == null || virtualIPId == null ? 1 : 0) != 0, (Object)"virtualIPType and virtualIPId cannot both be specified");
        if (virtualIPType != null) {
            return ImmutableSet.of((Object)ImmutableMap.of((Object)"type", (Object)virtualIPType.name()));
        }
        if (virtualIPId != null) {
            return ImmutableSet.of((Object)ImmutableMap.of((Object)"id", (Object)virtualIPId.toString()));
        }
        throw new IllegalArgumentException("virtualIPType or virtualIPId must be specified");
    }

    @Override
    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("protocol", (Object)this.protocol).add("port", (Object)this.port).add("nodes", (Object)this.nodes).add("timeout", (Object)this.timeout).add("algorithm", (Object)this.algorithm).add("timeout", (Object)this.timeout).add("sessionPersistenceType", (Object)this.getSessionPersistenceType()).add("connectionLogging", this.isConnectionLogging()).add("connectionThrottle", (Object)this.connectionThrottle).add("healthMonitor", (Object)this.healthMonitor).add("accessRules", this.accessRules).add("metadata", this.metadata).add("virtualIps", this.virtualIps);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder
    extends BaseLoadBalancer.Builder<AddNode, CreateLoadBalancer> {
        private VirtualIP.Type virtualIPType;
        private Integer virtualIPId;
        private Set<Map<String, String>> virtualIps;
        private Set<AccessRule> accessRules;
        private Map<String, String> metadata;

        public Builder virtualIPId(Integer virtualIPId) {
            this.virtualIPId = virtualIPId;
            return this;
        }

        public Builder virtualIPType(VirtualIP.Type virtualIPType) {
            this.virtualIPType = virtualIPType;
            return this;
        }

        private Builder virtualIPs(Set<Map<String, String>> virtualIPs) {
            this.virtualIps = virtualIPs;
            return this;
        }

        public Builder accessRules(Iterable<AccessRule> accessRules) {
            this.accessRules = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(accessRules, (Object)"accessRules")));
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
            return this;
        }

        public CreateLoadBalancer build() {
            if (this.virtualIps == null) {
                return new CreateLoadBalancer(this.name, this.protocol, this.port, this.nodes, this.algorithm, this.timeout, this.halfClosed, this.sessionPersistence, this.connectionLogging, this.connectionThrottle, this.healthMonitor, this.accessRules, this.metadata, this.virtualIPType, this.virtualIPId);
            }
            return new CreateLoadBalancer(this.name, this.protocol, this.port, this.nodes, this.algorithm, this.timeout, this.halfClosed, this.sessionPersistence, this.connectionLogging, this.connectionThrottle, this.healthMonitor, this.accessRules, this.metadata, this.virtualIps);
        }

        public Builder nodes(Iterable<AddNode> addNodes) {
            this.nodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(addNodes, (Object)"addNodes")));
            return this;
        }

        public Builder node(AddNode node) {
            this.nodes.add(Preconditions.checkNotNull((Object)node, (Object)"node"));
            return this;
        }

        public Builder algorithm(BaseLoadBalancer.Algorithm algorithm) {
            return (Builder)Builder.class.cast(super.algorithm(algorithm));
        }

        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        public Builder port(Integer port) {
            return (Builder)Builder.class.cast(super.port(port));
        }

        public Builder protocol(String protocol) {
            return (Builder)Builder.class.cast(super.protocol(protocol));
        }

        public Builder from(CreateLoadBalancer in) {
            return ((Builder)Builder.class.cast(super.from(in))).virtualIPs(in.virtualIps);
        }
    }
}

