/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.config.AuthenticationApiModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.trove.v1.TroveApi;
import org.jclouds.openstack.trove.v1.config.TroveHttpApiModule;
import org.jclouds.openstack.trove.v1.config.TroveParserModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value=ApiMetadata.class)
public class TroveApiMetadata
extends BaseHttpApiMetadata<TroveApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public TroveApiMetadata() {
        this(new Builder());
    }

    protected TroveApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "database");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<TroveApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-trove")).name("OpenStack Trove API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base URL ending in /v2.0/")).documentation(URI.create("http://api.openstack.org/"))).version("1.0")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(TroveApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationApiModule.class).add(KeystoneAuthenticationModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(TroveParserModule.class).add(TroveHttpApiModule.class).build());
        }

        public TroveApiMetadata build() {
            return new TroveApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

