/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.blobstore.functions.BlobToAzureBlob;
import org.jclouds.azureblob.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.logging.Logger;

public class AzureBlobBlockUploadStrategy
implements MultipartUploadStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    private Logger logger = Logger.NULL;
    private final AzureBlobClient client;
    private final PayloadSlicer slicer;
    private final BlobToAzureBlob blobToAzureBlob;

    @Inject
    AzureBlobBlockUploadStrategy(AzureBlobClient client, PayloadSlicer slicer, BlobToAzureBlob blobToAzureBlob) {
        this.client = client;
        this.slicer = slicer;
        this.blobToAzureBlob = blobToAzureBlob;
    }

    @Override
    public String execute(String container, Blob blob) {
        String blobName = blob.getMetadata().getName();
        Payload payload = blob.getPayload();
        Long length = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull((Object)length, (Object)"please invoke payload.getContentMetadata().setContentLength(length) prior to azure block upload");
        Preconditions.checkArgument((length <= 209715200000L ? 1 : 0) != 0);
        ArrayList blockIds = Lists.newArrayList();
        long bytesWritten = 0L;
        for (Payload block : this.slicer.slice(payload, 0x400000L)) {
            String blockName = blobName + "-" + UUID.randomUUID().toString();
            byte[] blockIdBytes = Hashing.md5().hashBytes(blockName.getBytes()).asBytes();
            String blockId = BaseEncoding.base64().encode(blockIdBytes);
            blockIds.add(blockId);
            this.client.putBlock(container, blobName, blockId, block);
            bytesWritten += block.getContentMetadata().getContentLength().longValue();
        }
        Preconditions.checkState((bytesWritten == length ? 1 : 0) != 0, (String)"Wrote %s bytes, but we wanted to write %s bytes", (Object[])new Object[]{bytesWritten, length});
        return this.client.putBlockList(container, this.blobToAzureBlob.apply(blob), (List<String>)blockIds);
    }
}

