/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.dynect.v3.domain.GeoRegionGroup;
import org.jclouds.dynect.v3.domain.Node;

public class GeoService {
    private final String name;
    private final boolean active;
    private final int ttl;
    private final List<Node> nodes;
    private final List<GeoRegionGroup> groups;

    private GeoService(String name, boolean active, int ttl, List<Node> nodes, List<GeoRegionGroup> groups) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.active = (Boolean)Preconditions.checkNotNull((Object)active, (Object)"active");
        this.ttl = (Integer)Preconditions.checkNotNull((Object)ttl, (Object)"ttl");
        this.nodes = (List)Preconditions.checkNotNull(nodes, (String)"nodes of %s", (Object[])new Object[]{name});
        this.groups = (List)Preconditions.checkNotNull(groups, (String)"groups of %s", (Object[])new Object[]{name});
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTTL() {
        return this.ttl;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<GeoRegionGroup> getGroups() {
        return this.groups;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.active, this.name, this.nodes, this.groups});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GeoService)) {
            return false;
        }
        GeoService that = (GeoService)GeoService.class.cast(obj);
        return Objects.equal((Object)this.active, (Object)that.active) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal(this.nodes, that.nodes) && Objects.equal(this.groups, that.groups);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("active", this.active).add("name", (Object)this.name).add("ttl", this.ttl).add("nodes", this.nodes).add("groups", this.groups).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return GeoService.builder().from(this);
    }

    public static class Builder {
        private String name;
        private boolean active;
        protected int ttl = -1;
        private ImmutableList.Builder<Node> nodes = ImmutableList.builder();
        private ImmutableList.Builder<GeoRegionGroup> groups = ImmutableList.builder();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder addNode(Node node) {
            this.nodes.add((Object)node);
            return this;
        }

        public Builder nodes(Iterable<Node> nodes) {
            this.nodes = ImmutableList.builder().addAll(nodes);
            return this;
        }

        public Builder addAllNodes(Iterable<Node> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public Builder addGroup(GeoRegionGroup group) {
            this.groups.add((Object)group);
            return this;
        }

        public Builder groups(Iterable<GeoRegionGroup> groups) {
            this.groups = ImmutableList.builder().addAll(groups);
            return this;
        }

        public Builder addAllGroups(Iterable<GeoRegionGroup> groups) {
            this.groups.addAll(groups);
            return this;
        }

        public GeoService build() {
            return new GeoService(this.name, this.active, this.ttl, (List)this.nodes.build(), (List)this.groups.build());
        }

        public Builder from(GeoService in) {
            return this.name(in.name).active(in.active).ttl(in.ttl).nodes(in.nodes).groups(in.groups);
        }
    }
}

