/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ObjectUtils;

class BeanTypeNotPresentCondition
implements ConfigurationCondition {
    private static final Log logger = LogFactory.getLog((String)"org.springframework.web.servlet.config.annotation.ViewResolution");
    private final Class<?> beanType;

    BeanTypeNotPresentCondition(Class<?> beanType) {
        this.beanType = beanType;
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConfigurableListableBeanFactory factory = context.getBeanFactory();
        Object[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, this.beanType, (boolean)false, (boolean)false);
        if (ObjectUtils.isEmpty((Object[])names)) {
            logger.debug((Object)("No bean of type [" + this.beanType + "]. Conditional configuration applies."));
            return true;
        }
        logger.debug((Object)("Found bean of type [" + this.beanType + "]. Conditional configuration does not apply."));
        return false;
    }
}

