/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class SecuritySshKey {
    private final int id;
    private final String key;
    private final String label;
    private final String fingerprint;
    private final String notes;
    private final String createDate;
    private final String modifyDate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SecuritySshKey.builder().fromSecuritySshKey(this);
    }

    @ConstructorProperties(value={"id", "key", "label", "name", "notes", "createDate", "modifyDate"})
    protected SecuritySshKey(int id, @Nullable String key, @Nullable String label, @Nullable String fingerprint, @Nullable String notes, @Nullable String createDate, @Nullable String modifyDate) {
        this.id = id;
        this.key = key;
        this.label = label;
        this.fingerprint = fingerprint;
        this.notes = notes;
        this.createDate = createDate;
        this.modifyDate = modifyDate;
    }

    public int getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public String getModifyDate() {
        return this.modifyDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecuritySshKey that = (SecuritySshKey)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.label, (Object)that.label) && Objects.equal((Object)this.fingerprint, (Object)that.fingerprint) && Objects.equal((Object)this.notes, (Object)that.notes) && Objects.equal((Object)this.createDate, (Object)that.createDate) && Objects.equal((Object)this.modifyDate, (Object)that.modifyDate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.key, this.label, this.fingerprint, this.notes, this.createDate, this.modifyDate});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("key", (Object)this.key).add("label", (Object)this.label).add("name", (Object)this.fingerprint).add("notes", (Object)this.notes).add("createDate", (Object)this.createDate).add("modifyDate", (Object)this.modifyDate).toString();
    }

    public static class Builder {
        protected int id;
        protected String key;
        protected String label;
        protected String fingerprint;
        protected String notes;
        protected String createDate;
        protected String modifyDate;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public Builder modifyDate(String modifyDate) {
            this.modifyDate = modifyDate;
            return this;
        }

        public SecuritySshKey build() {
            return new SecuritySshKey(this.id, this.key, this.label, this.fingerprint, this.notes, this.createDate, this.modifyDate);
        }

        public Builder fromSecuritySshKey(SecuritySshKey in) {
            return this.id(in.getId()).key(in.getKey()).label(in.getLabel()).fingerprint(in.getFingerprint()).notes(in.getNotes()).createDate(in.getCreateDate()).modifyDate(in.getModifyDate());
        }
    }
}

