/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.inject.Inject;
import java.util.Map;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ResourceRecordDetailHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ResourceRecordDetail> {
    private final DateService dateService;
    private ResourceRecordDetail.Builder rrm = ResourceRecordDetail.builder();
    private ResourceRecord.Builder rr = ResourceRecord.rrBuilder();

    @Inject
    private ResourceRecordDetailHandler(DateService dateService) {
        this.dateService = dateService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceRecordDetail getResult() {
        try {
            ResourceRecordDetail resourceRecordDetail = this.rrm.record(this.rr.build()).build();
            return resourceRecordDetail;
        }
        finally {
            this.rrm = ResourceRecordDetail.builder();
            this.rr = ResourceRecord.rrBuilder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"ResourceRecord")) {
            this.rrm.zoneId((String)attributes.get("ZoneId"));
            this.rrm.guid((String)attributes.get("Guid"));
            this.rrm.zoneName((String)attributes.get("ZoneName"));
            this.rrm.created(this.dateService.iso8601DateParse((String)attributes.get("Created")));
            this.rrm.modified(this.dateService.iso8601DateParse((String)attributes.get("Modified")));
            this.rr.type(Integer.parseInt((String)attributes.get("Type")));
            this.rr.name((String)attributes.get("DName"));
            this.rr.ttl(Integer.parseInt((String)attributes.get("TTL")));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"InfoValues")) {
            this.rr.rdata(attributes.values());
        }
    }
}

