/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.base.Preconditions;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public abstract class ElementTextHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<String> {
    private final String textElement;
    private StringBuilder currentText = new StringBuilder();
    private String text = null;

    private ElementTextHandler(String textElement) {
        this.textElement = (String)Preconditions.checkNotNull((Object)textElement, (Object)"textElement");
    }

    public String getResult() {
        return (String)Preconditions.checkNotNull((Object)this.text, (String)"%s not present in the response", (Object[])new Object[]{this.textElement});
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)this.textElement)) {
            this.text = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    public static class DirectionalPoolRecordID
    extends ElementTextHandler {
        public DirectionalPoolRecordID() {
            super("DirectionalPoolRecordID");
        }
    }

    public static class DirPoolID
    extends ElementTextHandler {
        public DirPoolID() {
            super("DirPoolID");
        }
    }

    public static class PoolRecordID
    extends ElementTextHandler {
        public PoolRecordID() {
            super("poolRecordID");
        }
    }

    public static class TCPoolID
    extends ElementTextHandler {
        public TCPoolID() {
            super("TCPoolID");
        }
    }

    public static class RRPoolID
    extends ElementTextHandler {
        public RRPoolID() {
            super("RRPoolID");
        }
    }

    public static class Guid
    extends ElementTextHandler {
        public Guid() {
            super("guid");
        }
    }
}

