/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class DirectionalGroupCoordinates {
    private final String zoneName;
    private final String recordName;
    private final int recordType;
    private final String groupName;

    private DirectionalGroupCoordinates(String zoneName, String recordName, int recordType, String groupName) {
        this.zoneName = (String)Preconditions.checkNotNull((Object)zoneName, (Object)"zoneName");
        this.recordName = (String)Preconditions.checkNotNull((Object)recordName, (Object)"recordName");
        Preconditions.checkArgument((recordType >= 0 ? 1 : 0) != 0, (String)"recordType of %s must be >= 0", (Object[])new Object[]{recordName});
        this.recordType = recordType;
        this.groupName = (String)Preconditions.checkNotNull((Object)groupName, (Object)"groupName");
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public int getRecordType() {
        return this.recordType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zoneName, this.recordName, this.recordType, this.groupName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionalGroupCoordinates that = (DirectionalGroupCoordinates)DirectionalGroupCoordinates.class.cast(obj);
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName) && Objects.equal((Object)this.recordName, (Object)that.recordName) && Objects.equal((Object)this.recordType, (Object)that.recordType) && Objects.equal((Object)this.groupName, (Object)that.groupName);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("zoneName", (Object)this.zoneName).add("recordName", (Object)this.recordName).add("recordType", this.recordType).add("groupName", (Object)this.groupName).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DirectionalGroupCoordinates.builder().from(this);
    }

    public static final class Builder {
        private String zoneName;
        private String recordName;
        private int recordType = -1;
        private String groupName;

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public Builder recordType(int recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public DirectionalGroupCoordinates build() {
            return new DirectionalGroupCoordinates(this.zoneName, this.recordName, this.recordType, this.groupName);
        }

        public Builder from(DirectionalGroupCoordinates in) {
            return this.zoneName(in.zoneName).recordName(in.zoneName).recordType(in.recordType).groupName(in.groupName);
        }
    }
}

