/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.importexport.model.GetShippingLabelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class GetShippingLabelRequestMarshaller
implements Marshaller<Request<GetShippingLabelRequest>, GetShippingLabelRequest> {
    public Request<GetShippingLabelRequest> marshall(GetShippingLabelRequest getShippingLabelRequest) {
        if (getShippingLabelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getShippingLabelRequest, "AmazonImportExport");
        request.addParameter("Action", "GetShippingLabel");
        request.addParameter("Version", "2010-06-01");
        List<String> jobIdsList = getShippingLabelRequest.getJobIds();
        int jobIdsListIndex = 1;
        for (String jobIdsListValue : jobIdsList) {
            if (jobIdsListValue != null) {
                request.addParameter("jobIds.member." + jobIdsListIndex, StringUtils.fromString((String)jobIdsListValue));
            }
            ++jobIdsListIndex;
        }
        if (getShippingLabelRequest.getName() != null) {
            request.addParameter("name", StringUtils.fromString((String)getShippingLabelRequest.getName()));
        }
        if (getShippingLabelRequest.getCompany() != null) {
            request.addParameter("company", StringUtils.fromString((String)getShippingLabelRequest.getCompany()));
        }
        if (getShippingLabelRequest.getPhoneNumber() != null) {
            request.addParameter("phoneNumber", StringUtils.fromString((String)getShippingLabelRequest.getPhoneNumber()));
        }
        if (getShippingLabelRequest.getCountry() != null) {
            request.addParameter("country", StringUtils.fromString((String)getShippingLabelRequest.getCountry()));
        }
        if (getShippingLabelRequest.getStateOrProvince() != null) {
            request.addParameter("stateOrProvince", StringUtils.fromString((String)getShippingLabelRequest.getStateOrProvince()));
        }
        if (getShippingLabelRequest.getCity() != null) {
            request.addParameter("city", StringUtils.fromString((String)getShippingLabelRequest.getCity()));
        }
        if (getShippingLabelRequest.getPostalCode() != null) {
            request.addParameter("postalCode", StringUtils.fromString((String)getShippingLabelRequest.getPostalCode()));
        }
        if (getShippingLabelRequest.getStreet1() != null) {
            request.addParameter("street1", StringUtils.fromString((String)getShippingLabelRequest.getStreet1()));
        }
        if (getShippingLabelRequest.getStreet2() != null) {
            request.addParameter("street2", StringUtils.fromString((String)getShippingLabelRequest.getStreet2()));
        }
        if (getShippingLabelRequest.getStreet3() != null) {
            request.addParameter("street3", StringUtils.fromString((String)getShippingLabelRequest.getStreet3()));
        }
        if (getShippingLabelRequest.getAPIVersion() != null) {
            request.addParameter("APIVersion", StringUtils.fromString((String)getShippingLabelRequest.getAPIVersion()));
        }
        return request;
    }
}

