/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.s3.domain.CanonicalUser;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.MutableObjectMetadataImpl;

public class ObjectMetadataBuilder {
    private final ContentMetadataBuilder contentMetadataBuilder = new ContentMetadataBuilder().contentType("binary/octet-stream");
    private String key;
    private String bucket;
    private URI uri;
    private ObjectMetadata.StorageClass storageClass = ObjectMetadata.StorageClass.STANDARD;
    private String cacheControl;
    private Date lastModified;
    private String eTag;
    private CanonicalUser owner;
    private Map<String, String> userMetadata = ImmutableMap.of();

    public static ObjectMetadataBuilder create() {
        return new ObjectMetadataBuilder();
    }

    public ObjectMetadataBuilder key(String key) {
        this.key = key;
        return this;
    }

    public ObjectMetadataBuilder bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public ObjectMetadataBuilder owner(CanonicalUser owner) {
        this.owner = owner;
        return this;
    }

    public ObjectMetadataBuilder eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public ObjectMetadataBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ObjectMetadataBuilder lastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public ObjectMetadataBuilder storageClass(ObjectMetadata.StorageClass storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public ObjectMetadataBuilder cacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public ObjectMetadataBuilder userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = ImmutableMap.copyOf(userMetadata);
        return this;
    }

    public ObjectMetadataBuilder contentDisposition(String contentDisposition) {
        this.contentMetadataBuilder.contentDisposition(contentDisposition);
        return this;
    }

    public ObjectMetadataBuilder contentEncoding(String contentEncoding) {
        this.contentMetadataBuilder.contentEncoding(contentEncoding);
        return this;
    }

    public ObjectMetadataBuilder contentLanguage(String contentLanguage) {
        this.contentMetadataBuilder.contentLanguage(contentLanguage);
        return this;
    }

    public ObjectMetadataBuilder contentLength(Long contentLength) {
        this.contentMetadataBuilder.contentLength(contentLength);
        return this;
    }

    public ObjectMetadataBuilder contentMD5(byte[] md5) {
        this.contentMetadataBuilder.contentMD5(md5);
        return this;
    }

    public ObjectMetadataBuilder contentType(String contentType) {
        this.contentMetadataBuilder.contentType(contentType);
        return this;
    }

    public ObjectMetadata build() {
        MutableObjectMetadataImpl toReturn = new MutableObjectMetadataImpl();
        toReturn.setContentMetadata((MutableContentMetadata)BaseMutableContentMetadata.fromContentMetadata((ContentMetadata)this.contentMetadataBuilder.build()));
        toReturn.setCacheControl(this.cacheControl);
        toReturn.setKey(this.key);
        toReturn.setBucket(this.bucket);
        toReturn.setUri(this.uri);
        toReturn.setETag(this.eTag);
        toReturn.setOwner(this.owner);
        toReturn.setStorageClass(this.storageClass);
        toReturn.setUserMetadata(this.userMetadata);
        toReturn.setLastModified(this.lastModified);
        return toReturn;
    }
}

