/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.cloudstack.domain.Account;
import org.jclouds.javax.annotation.Nullable;

public class User {
    private final String id;
    private final String name;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final Date created;
    private final State state;
    private final String account;
    private final Account.Type accountType;
    private final String domain;
    private final String domainId;
    private final String timeZone;
    private final String apiKey;
    private final String secretKey;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUser(this);
    }

    @ConstructorProperties(value={"id", "username", "firstname", "lastname", "email", "created", "state", "account", "accounttype", "domain", "domainid", "timezone", "apikey", "secretkey"})
    protected User(String id, @Nullable String name, @Nullable String firstName, @Nullable String lastName, @Nullable String email, @Nullable Date created, @Nullable State state, @Nullable String account, @Nullable Account.Type accountType, @Nullable String domain, @Nullable String domainId, @Nullable String timeZone, @Nullable String apiKey, @Nullable String secretKey) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = name;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.created = created;
        this.state = state;
        this.account = account;
        this.accountType = accountType;
        this.domain = domain;
        this.domainId = domainId;
        this.timeZone = timeZone;
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFirstName() {
        return this.firstName;
    }

    @Nullable
    public String getLastName() {
        return this.lastName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public Account.Type getAccountType() {
        return this.accountType;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getTimeZone() {
        return this.timeZone;
    }

    @Nullable
    public String getApiKey() {
        return this.apiKey;
    }

    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.firstName, this.lastName, this.email, this.created, this.state, this.account, this.accountType, this.domain, this.domainId, this.timeZone, this.apiKey, this.secretKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User that = (User)User.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.firstName, (Object)that.firstName) && Objects.equal((Object)this.lastName, (Object)that.lastName) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)((Object)this.accountType), (Object)((Object)that.accountType)) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.timeZone, (Object)that.timeZone) && Objects.equal((Object)this.apiKey, (Object)that.apiKey) && Objects.equal((Object)this.secretKey, (Object)that.secretKey);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("email", (Object)this.email).add("created", (Object)this.created).add("state", (Object)this.state).add("account", (Object)this.account).add("accountType", (Object)this.accountType).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("timeZone", (Object)this.timeZone).add("apiKey", (Object)this.apiKey).add("secretKey", (Object)this.secretKey);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String firstName;
        protected String lastName;
        protected String email;
        protected Date created;
        protected State state;
        protected String account;
        protected Account.Type accountType;
        protected String domain;
        protected String domainId;
        protected String timeZone;
        protected String apiKey;
        protected String secretKey;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T firstName(String firstName) {
            this.firstName = firstName;
            return this.self();
        }

        public T lastName(String lastName) {
            this.lastName = lastName;
            return this.self();
        }

        public T email(String email) {
            this.email = email;
            return this.self();
        }

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T state(State state) {
            this.state = state;
            return this.self();
        }

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T accountType(Account.Type accountType) {
            this.accountType = accountType;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this.self();
        }

        public T apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this.self();
        }

        public T secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this.self();
        }

        public User build() {
            return new User(this.id, this.name, this.firstName, this.lastName, this.email, this.created, this.state, this.account, this.accountType, this.domain, this.domainId, this.timeZone, this.apiKey, this.secretKey);
        }

        public T fromUser(User in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).firstName(in.getFirstName())).lastName(in.getLastName())).email(in.getEmail())).created(in.getCreated())).state(in.getState())).account(in.getAccount())).accountType(in.getAccountType())).domain(in.getDomain())).domainId(in.getDomainId())).timeZone(in.getTimeZone())).apiKey(in.getApiKey())).secretKey(in.getSecretKey());
        }
    }

    public static enum State {
        ENABLED,
        DISABLED,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

