/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class SshKeyPair {
    private final String fingerprint;
    private final String name;
    private final String privateKey;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSshKeyPair(this);
    }

    @ConstructorProperties(value={"fingerprint", "name", "privatekey"})
    protected SshKeyPair(@Nullable String fingerprint, String name, @Nullable String privateKey) {
        this.fingerprint = fingerprint;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.privateKey = privateKey;
    }

    @Nullable
    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fingerprint, this.name, this.privateKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SshKeyPair that = (SshKeyPair)SshKeyPair.class.cast(obj);
        return Objects.equal((Object)this.fingerprint, (Object)that.fingerprint) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.privateKey, (Object)that.privateKey);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("fingerprint", (Object)this.fingerprint).add("name", (Object)this.name).add("privateKey", (Object)this.privateKey);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String fingerprint;
        protected String name;
        protected String privateKey;

        protected abstract T self();

        public T fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this.self();
        }

        public SshKeyPair build() {
            return new SshKeyPair(this.fingerprint, this.name, this.privateKey);
        }

        public T fromSshKeyPair(SshKeyPair in) {
            return ((Builder)((Builder)this.fingerprint(in.getFingerprint())).name(in.getName())).privateKey(in.getPrivateKey());
        }
    }
}

