/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Provider;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.s3.blobstore.S3BlobRequestSigner;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.filters.RequestAuthorizeSignature;

public class AWSS3BlobRequestSigner
extends S3BlobRequestSigner<AWSS3Client> {
    public static final String TEMPORARY_SIGNATURE_PARAM = "Signature";
    private final RequestAuthorizeSignature authSigner;
    private final String identity;
    private final DateService dateService;
    private final com.google.inject.Provider<String> timeStampProvider;

    @Inject
    public AWSS3BlobRequestSigner(RestAnnotationProcessor processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Class<AWSS3Client> interfaceClass, @Provider Supplier<Credentials> credentials, RequestAuthorizeSignature authSigner, @TimeStamp com.google.inject.Provider<String> timeStampProvider, DateService dateService) throws SecurityException, NoSuchMethodException {
        super(processor, blobToObject, blob2HttpGetOptions, interfaceClass);
        this.authSigner = authSigner;
        this.identity = ((Credentials)credentials.get()).identity;
        this.dateService = dateService;
        this.timeStampProvider = timeStampProvider;
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)this.getMethod, (List)ImmutableList.of((Object)container, (Object)name)));
        return BlobStoreUtils.cleanRequest((HttpRequest)this.signForTemporaryAccess((HttpRequest)request, timeInSeconds));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create((Invokable)this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))));
        return BlobStoreUtils.cleanRequest((HttpRequest)this.signForTemporaryAccess((HttpRequest)request, timeInSeconds));
    }

    private HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        String dateString = request.getFirstHeaderOrNull("Date");
        if (dateString == null) {
            dateString = (String)this.timeStampProvider.get();
        }
        Date date = this.dateService.rfc1123DateParse(dateString);
        String expiration = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(date.getTime()) + timeInSeconds);
        HttpRequest.Builder builder = (HttpRequest.Builder)request.toBuilder().replaceHeader("Date", new String[]{expiration});
        String stringToSign = this.authSigner.createStringToSign(builder.build());
        String signature = this.authSigner.sign(stringToSign);
        try {
            signature = URLEncoder.encode(signature, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + signature, e);
        }
        HttpRequest ret = builder.addQueryParam("Expires", new String[]{expiration}).addQueryParam("AWSAccessKeyId", new String[]{this.identity}).addQueryParam(TEMPORARY_SIGNATURE_PARAM, new String[]{signature}).build();
        return ret;
    }
}

