/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import java.util.Date;
import javax.inject.Inject;
import org.jclouds.cloudwatch.domain.Datapoint;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;

public class DatapointHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Datapoint> {
    private StringBuilder currentText = new StringBuilder();
    protected final DateService dateService;
    private Double average;
    private Double maximum;
    private Double minimum;
    private Date timestamp;
    private Double samples;
    private Double sum;
    private Unit unit;
    private String customUnit;

    @Inject
    public DatapointHandler(DateService dateService) {
        this.dateService = dateService;
    }

    public Datapoint getResult() {
        Datapoint datapoint = new Datapoint(this.average, this.maximum, this.minimum, this.timestamp, this.samples, this.sum, this.unit, this.customUnit);
        this.average = null;
        this.maximum = null;
        this.minimum = null;
        this.timestamp = null;
        this.samples = null;
        this.sum = null;
        this.unit = null;
        this.customUnit = null;
        return datapoint;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Average")) {
            this.average = this.doubleOrNull();
        } else if (qName.equals("Maximum")) {
            this.maximum = this.doubleOrNull();
        } else if (qName.equals("Minimum")) {
            this.minimum = this.doubleOrNull();
        } else if (qName.equals("Timestamp")) {
            this.timestamp = this.dateService.iso8601SecondsDateParse(this.currentText.toString().trim());
        } else if (qName.equals("SampleCount")) {
            this.samples = this.doubleOrNull();
        } else if (qName.equals("Sum")) {
            this.sum = this.doubleOrNull();
        } else if (qName.equals("Unit")) {
            this.unit = Unit.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("CustomUnit")) {
            this.customUnit = this.currentText.toString().trim();
        }
        this.currentText.setLength(0);
    }

    private Double doubleOrNull() {
        String string = this.currentText.toString().trim();
        if (!string.equals("")) {
            return new Double(string);
        }
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

