/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cim;

import org.jclouds.cim.SettingData;

public abstract class ManagedElement
extends SettingData {
    protected final String caption;
    protected final String description;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return ManagedElement.builder().fromManagedElement(this);
    }

    public ManagedElement(String elementName, String instanceID, String caption, String description) {
        super(elementName, instanceID);
        this.caption = caption;
        this.description = description;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return String.format("[elementName=%s, instanceID=%s, caption=%s, description=%s]", this.elementName, this.instanceID, this.caption, this.description);
    }

    public static class Builder
    extends SettingData.Builder {
        protected String caption;
        protected String description;

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder fromManagedElement(ManagedElement in) {
            return this.caption(in.getCaption()).description(in.getDescription()).fromSettingData(in);
        }

        @Override
        public Builder fromSettingData(SettingData in) {
            return (Builder)Builder.class.cast(super.fromSettingData(in));
        }

        @Override
        public Builder elementName(String elementName) {
            return (Builder)Builder.class.cast(super.elementName(elementName));
        }

        @Override
        public Builder instanceID(String instanceID) {
            return (Builder)Builder.class.cast(super.instanceID(instanceID));
        }
    }
}

