/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Tag;
import org.jclouds.softlayer.domain.TagType;

public class TagReference {
    private final int id;
    private final int usrRecordId;
    private final int tagTypeId;
    private final int tagId;
    private final int resourceTableId;
    private final int empRecordId;
    private final Tag tag;
    private final TagType tagType;

    @ConstructorProperties(value={"id", "usrRecordId", "tagTypeId", "tagId", "resourceTableId", "empRecordId", "tag", "tagType"})
    public TagReference(int id, int usrRecordId, int tagTypeId, int tagId, int resourceTableId, int empRecordId, @Nullable Tag tag, @Nullable TagType tagType) {
        this.id = id;
        this.usrRecordId = usrRecordId;
        this.tagTypeId = tagTypeId;
        this.tagId = tagId;
        this.resourceTableId = resourceTableId;
        this.empRecordId = empRecordId;
        this.tag = tag;
        this.tagType = tagType;
    }

    public int getId() {
        return this.id;
    }

    public int getUsrRecordId() {
        return this.usrRecordId;
    }

    public int getTagTypeId() {
        return this.tagTypeId;
    }

    public int getTagId() {
        return this.tagId;
    }

    public int getResourceTableId() {
        return this.resourceTableId;
    }

    public int getEmpRecordId() {
        return this.empRecordId;
    }

    public Tag getTag() {
        return this.tag;
    }

    public TagType getTagType() {
        return this.tagType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagReference that = (TagReference)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.usrRecordId, (Object)that.usrRecordId) && Objects.equal((Object)this.tagTypeId, (Object)that.tagTypeId) && Objects.equal((Object)this.tagId, (Object)that.tagId) && Objects.equal((Object)this.resourceTableId, (Object)that.resourceTableId) && Objects.equal((Object)this.empRecordId, (Object)that.empRecordId) && Objects.equal((Object)this.tag, (Object)that.tag) && Objects.equal((Object)this.tagType, (Object)that.tagType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.usrRecordId, this.tagTypeId, this.tagId, this.resourceTableId, this.empRecordId, this.tag, this.tagType});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("usrRecordId", this.usrRecordId).add("tagTypeId", this.tagTypeId).add("tagId", this.tagId).add("resourceTableId", this.resourceTableId).add("empRecordId", this.empRecordId).add("tag", (Object)this.tag).add("tagType", (Object)this.tagType).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return TagReference.builder().fromTagReference(this);
    }

    public static class Builder {
        private int id;
        private int usrRecordId;
        private int tagTypeId;
        private int tagId;
        private int resourceTableId;
        private int empRecordId;
        private Tag tag;
        private TagType tagType;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder usrRecordId(int usrRecordId) {
            this.usrRecordId = usrRecordId;
            return this;
        }

        public Builder tagTypeId(int tagTypeId) {
            this.tagTypeId = tagTypeId;
            return this;
        }

        public Builder tagId(int tagId) {
            this.tagId = tagId;
            return this;
        }

        public Builder resourceTableId(int resourceTableId) {
            this.resourceTableId = resourceTableId;
            return this;
        }

        public Builder empRecordId(int empRecordId) {
            this.empRecordId = empRecordId;
            return this;
        }

        public Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public Builder tagType(TagType tagType) {
            this.tagType = tagType;
            return this;
        }

        public TagReference build() {
            return new TagReference(this.id, this.usrRecordId, this.tagTypeId, this.tagId, this.resourceTableId, this.empRecordId, this.tag, this.tagType);
        }

        public Builder fromTagReference(TagReference in) {
            return this.id(in.getId()).usrRecordId(in.getUsrRecordId()).tagTypeId(in.getTagTypeId()).tagId(in.getTagId()).resourceTableId(in.getResourceTableId()).empRecordId(in.getResourceTableId()).tag(in.getTag()).tagType(in.getTagType());
        }
    }
}

