/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.openstack.nova.v2_0.domain.Network;
import org.jclouds.scriptbuilder.domain.Statement;

public class NovaTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected boolean autoAssignFloatingIp = false;
    protected Optional<Set<String>> floatingIpPoolNames = Optional.absent();
    protected boolean generateKeyPair = false;
    protected String keyPairName;
    protected byte[] userData;
    protected String diskConfig;
    protected boolean configDrive;
    protected Set<Network> novaNetworks;
    protected String availabilityZone;
    public static final NovaTemplateOptions NONE = new NovaTemplateOptions();

    public NovaTemplateOptions clone() {
        NovaTemplateOptions options = new NovaTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof NovaTemplateOptions) {
            NovaTemplateOptions eTo = (NovaTemplateOptions)NovaTemplateOptions.class.cast(to);
            eTo.autoAssignFloatingIp(this.shouldAutoAssignFloatingIp());
            if (this.getFloatingIpPoolNames().isPresent()) {
                eTo.floatingIpPoolNames((Iterable)this.getFloatingIpPoolNames().get());
            }
            if (this.getSecurityGroupNames().isPresent()) {
                eTo.securityGroupNames((Iterable)this.getSecurityGroupNames().get());
            }
            eTo.generateKeyPair(this.shouldGenerateKeyPair());
            eTo.keyPairName(this.getKeyPairName());
            if (this.getUserData() != null) {
                eTo.userData(this.getUserData());
            }
            if (this.getDiskConfig() != null) {
                eTo.diskConfig(this.getDiskConfig());
            }
            eTo.configDrive(this.getConfigDrive());
            eTo.novaNetworks(this.getNovaNetworks());
            eTo.availabilityZone(this.getAvailabilityZone());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NovaTemplateOptions that = (NovaTemplateOptions)NovaTemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal((Object)this.autoAssignFloatingIp, (Object)that.autoAssignFloatingIp) && Objects.equal(this.floatingIpPoolNames, that.floatingIpPoolNames) && Objects.equal((Object)this.generateKeyPair, (Object)that.generateKeyPair) && Objects.equal((Object)this.keyPairName, (Object)that.keyPairName) && Arrays.equals(this.userData, that.userData) && Objects.equal((Object)this.diskConfig, (Object)that.diskConfig) && Objects.equal((Object)this.configDrive, (Object)that.configDrive) && Objects.equal(this.novaNetworks, that.novaNetworks) && Objects.equal((Object)this.availabilityZone, (Object)that.availabilityZone);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.autoAssignFloatingIp, this.floatingIpPoolNames, this.generateKeyPair, this.keyPairName, this.userData, this.diskConfig, this.configDrive, this.novaNetworks, this.availabilityZone});
    }

    public Objects.ToStringHelper string() {
        Objects.ToStringHelper toString = super.string();
        if (!this.autoAssignFloatingIp) {
            toString.add("autoAssignFloatingIp", this.autoAssignFloatingIp);
        }
        if (this.floatingIpPoolNames.isPresent()) {
            toString.add("floatingIpPoolNames", this.floatingIpPoolNames.get());
        }
        if (this.generateKeyPair) {
            toString.add("generateKeyPair", this.generateKeyPair);
        }
        toString.add("keyPairName", (Object)this.keyPairName);
        toString.add("userData", (Object)this.userData);
        toString.add("diskConfig", (Object)this.diskConfig);
        toString.add("configDrive", this.configDrive);
        toString.add("novaNetworks", this.novaNetworks);
        toString.add("availabilityZone", (Object)this.availabilityZone);
        return toString;
    }

    public NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
        this.autoAssignFloatingIp = enable;
        return this;
    }

    public NovaTemplateOptions floatingIpPoolNames(String ... floatingIpPoolNames) {
        return this.floatingIpPoolNames((Iterable<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)floatingIpPoolNames, (Object)"floatingIpPoolNames"))));
    }

    public NovaTemplateOptions floatingIpPoolNames(Iterable<String> floatingIpPoolNames) {
        for (String groupName : (Iterable)Preconditions.checkNotNull(floatingIpPoolNames, (Object)"floatingIpPoolNames")) {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)groupName), (Object)"all floating-ip-pool-names must be non-empty");
        }
        this.floatingIpPoolNames = Optional.of((Object)ImmutableSet.copyOf(floatingIpPoolNames));
        return this;
    }

    public NovaTemplateOptions generateKeyPair(boolean enable) {
        this.generateKeyPair = enable;
        return this;
    }

    public NovaTemplateOptions keyPairName(String keyPairName) {
        this.keyPairName = keyPairName;
        return this;
    }

    @Deprecated
    public NovaTemplateOptions securityGroupNames(String ... securityGroupNames) {
        return this.securityGroupNames((Iterable<String>)ImmutableSet.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)securityGroupNames, (Object)"securityGroupNames"))));
    }

    @Deprecated
    public NovaTemplateOptions securityGroupNames(Iterable<String> securityGroupNames) {
        for (String groupName : (Iterable)Preconditions.checkNotNull(securityGroupNames, (Object)"securityGroupNames")) {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)groupName), (Object)"all security groups must be non-empty");
        }
        this.securityGroups(securityGroupNames);
        return this;
    }

    public boolean shouldAutoAssignFloatingIp() {
        return this.autoAssignFloatingIp;
    }

    public NovaTemplateOptions availabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Optional<Set<String>> getFloatingIpPoolNames() {
        return this.floatingIpPoolNames;
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public boolean shouldGenerateKeyPair() {
        return this.generateKeyPair;
    }

    @Deprecated
    public Optional<Set<String>> getSecurityGroupNames() {
        return this.getGroups().isEmpty() ? Optional.absent() : Optional.of((Object)this.getGroups());
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public String getDiskConfig() {
        return this.diskConfig;
    }

    public boolean getConfigDrive() {
        return this.configDrive;
    }

    public Set<Network> getNovaNetworks() {
        return this.novaNetworks;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public NovaTemplateOptions blockOnPort(int port, int seconds) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public NovaTemplateOptions inboundPorts(int ... ports) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public NovaTemplateOptions authorizePublicKey(String publicKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public NovaTemplateOptions installPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public NovaTemplateOptions dontAuthorizePublicKey() {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public NovaTemplateOptions nameTask(String name) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.nameTask(name));
    }

    public NovaTemplateOptions runAsRoot(boolean runAsRoot) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public NovaTemplateOptions runScript(Statement script) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.runScript(script));
    }

    public NovaTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public NovaTemplateOptions overrideLoginPassword(String password) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public NovaTemplateOptions overrideLoginUser(String loginUser) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public NovaTemplateOptions userMetadata(String key, String value) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public NovaTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public NovaTemplateOptions networks(Iterable<String> networks) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.networks(networks));
    }

    public NovaTemplateOptions networks(String ... networks) {
        return (NovaTemplateOptions)NovaTemplateOptions.class.cast(super.networks(networks));
    }

    public NovaTemplateOptions userData(byte[] userData) {
        Preconditions.checkArgument((((byte[])Preconditions.checkNotNull((Object)userData, (Object)"userData")).length <= 16384 ? 1 : 0) != 0, (Object)"userData cannot be larger than 16kb");
        this.userData = userData;
        return this;
    }

    public NovaTemplateOptions diskConfig(String diskConfig) {
        this.diskConfig = diskConfig;
        return this;
    }

    public NovaTemplateOptions configDrive(boolean configDrive) {
        this.configDrive = configDrive;
        return this;
    }

    public NovaTemplateOptions novaNetworks(Set<Network> novaNetworks) {
        this.novaNetworks = novaNetworks;
        return this;
    }

    public static class Builder {
        public static NovaTemplateOptions autoAssignFloatingIp(boolean enable) {
            return new NovaTemplateOptions().autoAssignFloatingIp(enable);
        }

        public NovaTemplateOptions floatingIpPoolNames(String ... floatingIpPoolNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.floatingIpPoolNames(floatingIpPoolNames));
        }

        public NovaTemplateOptions floatingIpPoolNames(Iterable<String> floatingIpPoolNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.floatingIpPoolNames(floatingIpPoolNames));
        }

        public static NovaTemplateOptions generateKeyPair(boolean enable) {
            return new NovaTemplateOptions().generateKeyPair(enable);
        }

        public static NovaTemplateOptions keyPairName(String keyPairName) {
            return new NovaTemplateOptions().keyPairName(keyPairName);
        }

        public static NovaTemplateOptions securityGroupNames(String ... groupNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static NovaTemplateOptions securityGroupNames(Iterable<String> groupNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.securityGroupNames(groupNames));
        }

        public static NovaTemplateOptions inboundPorts(int ... ports) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static NovaTemplateOptions blockOnPort(int port, int seconds) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static NovaTemplateOptions installPrivateKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static NovaTemplateOptions authorizePublicKey(String rsaKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static NovaTemplateOptions userMetadata(Map<String, String> userMetadata) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static NovaTemplateOptions nodeNames(Iterable<String> nodeNames) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static NovaTemplateOptions networks(Iterable<String> networks) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.networks((Iterable)networks));
        }

        public static NovaTemplateOptions overrideLoginUser(String user) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static NovaTemplateOptions overrideLoginPassword(String password) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static NovaTemplateOptions overrideLoginPrivateKey(String privateKey) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static NovaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static NovaTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static NovaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        public static NovaTemplateOptions userData(byte[] userData) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.userData(userData));
        }

        public static NovaTemplateOptions diskConfig(String diskConfig) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.diskConfig(diskConfig));
        }

        public static NovaTemplateOptions configDrive(boolean configDrive) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.configDrive(configDrive));
        }

        public static NovaTemplateOptions novaNetworks(Set<Network> novaNetworks) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return (NovaTemplateOptions)NovaTemplateOptions.class.cast(options.novaNetworks(novaNetworks));
        }

        public static NovaTemplateOptions availabilityZone(String availabilityZone) {
            NovaTemplateOptions options = new NovaTemplateOptions();
            return options.availabilityZone(availabilityZone);
        }
    }
}

