/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;

public class RemoveFloatingIpFromNodeAndDeallocate
implements Function<RegionAndId, RegionAndId> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final NovaApi novaApi;
    private final LoadingCache<RegionAndId, Iterable<? extends FloatingIP>> floatingIpCache;

    @Inject
    public RemoveFloatingIpFromNodeAndDeallocate(NovaApi novaApi, @Named(value="FLOATINGIP") LoadingCache<RegionAndId, Iterable<? extends FloatingIP>> floatingIpCache) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.floatingIpCache = (LoadingCache)Preconditions.checkNotNull(floatingIpCache, (Object)"floatingIpCache");
    }

    public RegionAndId apply(RegionAndId id) {
        FloatingIPApi floatingIpApi = (FloatingIPApi)this.novaApi.getFloatingIPApi(id.getRegion()).get();
        for (FloatingIP ip : (Iterable)this.floatingIpCache.getUnchecked((Object)id)) {
            this.logger.debug(">> removing floatingIp(%s) from node(%s)", new Object[]{ip, id});
            floatingIpApi.removeFromServer(ip.getIp(), id.getId());
            this.logger.debug(">> deallocating floatingIp(%s)", new Object[]{ip});
            floatingIpApi.delete(ip.getId());
        }
        this.floatingIpCache.invalidate((Object)id);
        return id;
    }

    public String toString() {
        return Objects.toStringHelper((String)"RemoveFloatingIpFromNodeAndDecreate").toString();
    }
}

