/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.net.URI;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.LoadBalancerApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.LB;
import org.jclouds.rest.InvocationContext;

public class ParseLoadBalancers
implements Function<HttpResponse, IterableWithMarker<LoadBalancer>>,
InvocationContext<ParseLoadBalancers> {
    private final ParseJson<LoadBalancers> json;
    private final ConvertLB.Factory factory;
    private ConvertLB convertLB;

    @Inject
    ParseLoadBalancers(ParseJson<LoadBalancers> json, ConvertLB.Factory factory) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
        this.factory = (ConvertLB.Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
    }

    public IterableWithMarker<LoadBalancer> apply(HttpResponse arg0) {
        LoadBalancers lbs = (LoadBalancers)((Object)this.json.apply(arg0));
        if (lbs.isEmpty()) {
            return IterableWithMarkers.EMPTY;
        }
        Iterable transform = Iterables.transform((Iterable)((Object)lbs), (Function)this.convertLB);
        IterableWithMarker iterableWithMarker = IterableWithMarkers.from((Iterable)transform);
        return iterableWithMarker;
    }

    public ParseLoadBalancers setContext(HttpRequest request) {
        return this.setEndpointAndRegion(request.getEndpoint());
    }

    ParseLoadBalancers setEndpointAndRegion(URI endpoint) {
        String region = endpoint.getHost().substring(0, endpoint.getHost().indexOf(46));
        this.convertLB = this.factory.createForEndpointAndRegion(endpoint, region);
        return this;
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<LoadBalancer, ToPagedIterable> {
        private final CloudLoadBalancersApi api;

        @Inject
        protected ToPagedIterable(CloudLoadBalancersApi api) {
            this.api = (CloudLoadBalancersApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<LoadBalancer>> markerToNextForArg0(Optional<Object> arg0) {
            String region = arg0.get().toString();
            final LoadBalancerApi loadBalancerApi = this.api.getLoadBalancerApi(region);
            return new Function<Object, IterableWithMarker<LoadBalancer>>(){

                public IterableWithMarker<LoadBalancer> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return loadBalancerApi.list(paginationOptions);
                }

                public String toString() {
                    return "list()";
                }
            };
        }
    }

    static class LoadBalancers
    extends PaginatedCollection<LB> {
        @ConstructorProperties(value={"loadBalancers", "loadBalancers_links"})
        protected LoadBalancers(Iterable<LB> loadBalancers, Iterable<Link> loadBalancers_links) {
            super(loadBalancers, loadBalancers_links);
        }
    }
}

