/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.features;

import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.v1.binders.BindMetadataToJsonPayload;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AddNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Metadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.Node;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.UpdateNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseMetadata;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseNode;
import org.jclouds.rackspace.cloudloadbalancers.v1.functions.ParseNodes;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@RequestFilters(value={AuthenticateRequest.class})
public interface NodeApi {
    @Named(value="node:add")
    @POST
    @SelectJson(value={"nodes"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/nodes")
    public Set<Node> add(@WrapWith(value="nodes") Iterable<AddNode> var1);

    @Named(value="node:update")
    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/nodes/{id}")
    public void update(@PathParam(value="id") int var1, @WrapWith(value="node") UpdateNode var2);

    @Named(value="node:list")
    @GET
    @ResponseParser(value=ParseNodes.class)
    @Transform(value=ParseNodes.ToPagedIterable.class)
    @Consumes(value={"application/json"})
    @Path(value="/nodes")
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Node> list();

    @Named(value="node:list")
    @GET
    @ResponseParser(value=ParseNodes.class)
    @Consumes(value={"application/json"})
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/nodes")
    public IterableWithMarker<Node> list(PaginationOptions var1);

    @Named(value="node:get")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseNode.class)
    @Path(value="/nodes/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Node get(@PathParam(value="id") int var1);

    @Named(value="node:remove")
    @DELETE
    @Path(value="/nodes/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    public void remove(@PathParam(value="id") int var1);

    @Named(value="node:remove")
    @DELETE
    @Path(value="/nodes")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    public void remove(@QueryParam(value="id") Iterable<Integer> var1);

    @Named(value="node:createmetadata")
    @POST
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseMetadata.class)
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @Path(value="/nodes/{id}/metadata")
    public Metadata createMetadata(@PathParam(value="id") int var1, @BinderParam(value=BindMetadataToJsonPayload.class) Map<String, String> var2);

    @Named(value="node:getmetadata")
    @GET
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseMetadata.class)
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @Path(value="/nodes/{id}/metadata")
    public Metadata getMetadata(@PathParam(value="id") int var1);

    @Named(value="node:updatemetadatum")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Payload(value="%7B\"meta\":%7B\"value\":\"{value}\"%7D%7D")
    @Path(value="/nodes/{id}/metadata/{metadatumId}")
    public boolean updateMetadatum(@PathParam(value="id") int var1, @PathParam(value="metadatumId") int var2, @PayloadParam(value="value") String var3);

    @Named(value="node:deletemetadatum")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @Path(value="/nodes/{id}/metadata/{metadatumId}")
    public boolean deleteMetadatum(@PathParam(value="id") int var1, @PathParam(value="metadatumId") int var2);

    @Named(value="node:deletemetadata")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Consumes(value={"*/*"})
    @Path(value="/nodes/{id}/metadata")
    public boolean deleteMetadata(@PathParam(value="id") int var1, @QueryParam(value="id") Iterable<Integer> var2);
}

