/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.AccountUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerInfo;

public final class HistoricalUsage {
    private final int accountId;
    private final Map<String, Iterable<AccountUsage>> accountUsage;
    private final Iterable<LoadBalancerInfo> loadBalancerUsages;

    @ConstructorProperties(value={"accountId", "accountUsage", "loadBalancerUsages"})
    protected HistoricalUsage(int accountId, Map<String, Iterable<AccountUsage>> accountUsage, Iterable<LoadBalancerInfo> loadBalancerUsages) {
        this.accountId = accountId;
        this.accountUsage = (Map)Preconditions.checkNotNull(accountUsage, (Object)"accountUsage");
        this.loadBalancerUsages = (Iterable)Preconditions.checkNotNull(loadBalancerUsages, (Object)"loadBalancerUsages");
    }

    public int getAccountId() {
        return this.accountId;
    }

    public Iterable<AccountUsage> getAccountUsage() {
        return (Iterable)Iterables.get(this.accountUsage.values(), (int)0);
    }

    public Iterable<LoadBalancerInfo> getLoadBalancerInfo() {
        return this.loadBalancerUsages;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HistoricalUsage that = (HistoricalUsage)HistoricalUsage.class.cast(obj);
        return Objects.equal((Object)this.accountId, (Object)that.accountId);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("accountId", this.accountId).add("accountUsage", this.getAccountUsage()).add("loadBalancerInfo", this.loadBalancerUsages).toString();
    }
}

