/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.config;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.domain.SnapshotExtendedAttributes;
import org.jclouds.openstack.cinder.v1.domain.Volume;

public class CinderParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public Map<Type, Object> provideCustomAdapterBindings() {
        return ImmutableMap.of(Snapshot.class, (Object)new SnapshotAdapter());
    }

    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
    }

    @Singleton
    public static class SnapshotAdapter
    implements JsonDeserializer<Snapshot> {
        public Snapshot deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            Snapshot snapshotBase = this.apply((SnapshotInternal)context.deserialize(jsonElement, SnapshotInternal.class));
            Snapshot.Builder result = Snapshot.builder().fromSnapshot(snapshotBase);
            SnapshotExtendedAttributes extendedAttributes = (SnapshotExtendedAttributes)context.deserialize(jsonElement, SnapshotExtendedAttributes.class);
            if (!Objects.equal((Object)extendedAttributes, (Object)SnapshotExtendedAttributes.builder().build())) {
                result.extendedAttributes(extendedAttributes);
            }
            return result.build();
        }

        public Snapshot apply(Snapshot in) {
            return in.toBuilder().build();
        }

        private static class SnapshotInternal
        extends Snapshot {
            @ConstructorProperties(value={"id", "volume_id", "status", "size", "created_at", "display_name", "display_description", "extendedAttributes"})
            protected SnapshotInternal(String id, String volumeId, Volume.Status status, int size, @Nullable Date created, @Nullable String name, @Nullable String description, @Nullable SnapshotExtendedAttributes extendedAttributes) {
                super(id, volumeId, status, size, created, name, description, extendedAttributes);
            }
        }
    }
}

