/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.strategy.DeleteAllClientsInList;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllClientsInListImpl
implements DeleteAllClientsInList {
    protected final ChefApi api;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    DeleteAllClientsInListImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ChefApi api) {
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecuor");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    @Override
    public void execute(Iterable<String> names) {
        this.execute(this.userExecutor, names);
    }

    @Override
    public void execute(final ListeningExecutorService executor, Iterable<String> names) {
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(names, (Function)new Function<String, ListenableFuture<Client>>(){

            public ListenableFuture<Client> apply(final String input) {
                return executor.submit((Callable)new Callable<Client>(){

                    @Override
                    public Client call() throws Exception {
                        return DeleteAllClientsInListImpl.this.api.deleteClient(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("deleting clients: %s", Joiner.on((char)',').join(names)), new Object[0]);
        Futures.getUnchecked((Future)futures);
    }
}

