/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.query;

import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.repository.Query;
import org.springframework.ldap.repository.query.AbstractLdapRepositoryQuery;
import org.springframework.ldap.repository.query.LdapQueryMethod;
import org.springframework.util.Assert;

public class AnnotatedLdapRepositoryQuery
extends AbstractLdapRepositoryQuery {
    private final Query queryAnnotation;

    public AnnotatedLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> clazz, LdapOperations ldapOperations) {
        super(queryMethod, clazz, ldapOperations);
        this.queryAnnotation = queryMethod.getQueryAnnotation();
        Assert.notNull((Object)((Object)queryMethod), (String)"Annotation must be present");
        Assert.hasLength((String)this.queryAnnotation.value(), (String)"Query filter must be specified");
    }

    @Override
    protected LdapQuery createQuery(Object[] parameters) {
        return LdapQueryBuilder.query().base(this.queryAnnotation.base()).searchScope(this.queryAnnotation.searchScope()).countLimit(this.queryAnnotation.countLimit()).timeLimit(this.queryAnnotation.timeLimit()).filter(this.queryAnnotation.value(), parameters);
    }
}

