/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.script.ExecutableMongoScript;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class DefaultScriptOperations
implements ScriptOperations {
    private static final String SCRIPT_COLLECTION_NAME = "system.js";
    private static final String SCRIPT_NAME_PREFIX = "func_";
    private final MongoOperations mongoOperations;

    public DefaultScriptOperations(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        this.mongoOperations = mongoOperations;
    }

    @Override
    public NamedMongoScript register(ExecutableMongoScript script) {
        return this.register(new NamedMongoScript(DefaultScriptOperations.generateScriptName(), script));
    }

    @Override
    public NamedMongoScript register(NamedMongoScript script) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        this.mongoOperations.save(script, SCRIPT_COLLECTION_NAME);
        return script;
    }

    @Override
    public Object execute(final ExecutableMongoScript script, final Object ... args) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        return this.mongoOperations.execute(new DbCallback<Object>(){

            @Override
            public Object doInDB(DB db) throws MongoException, DataAccessException {
                return db.eval(script.getCode(), DefaultScriptOperations.this.convertScriptArgs(args));
            }
        });
    }

    @Override
    public Object call(final String scriptName, final Object ... args) {
        Assert.hasText((String)scriptName, (String)"ScriptName must not be null or empty!");
        return this.mongoOperations.execute(new DbCallback<Object>(){

            @Override
            public Object doInDB(DB db) throws MongoException, DataAccessException {
                return db.eval(String.format("%s(%s)", scriptName, DefaultScriptOperations.this.convertAndJoinScriptArgs(args)), new Object[0]);
            }
        });
    }

    @Override
    public boolean exists(String scriptName) {
        Assert.hasText((String)scriptName, (String)"ScriptName must not be null or empty!");
        return this.mongoOperations.exists(Query.query(Criteria.where("name").is(scriptName)), NamedMongoScript.class, SCRIPT_COLLECTION_NAME);
    }

    @Override
    public Set<String> getScriptNames() {
        List<NamedMongoScript> scripts = this.mongoOperations.findAll(NamedMongoScript.class, SCRIPT_COLLECTION_NAME);
        if (CollectionUtils.isEmpty(scripts)) {
            return Collections.emptySet();
        }
        HashSet<String> scriptNames = new HashSet<String>();
        for (NamedMongoScript script : scripts) {
            scriptNames.add(script.getName());
        }
        return scriptNames;
    }

    private Object[] convertScriptArgs(Object ... args) {
        if (ObjectUtils.isEmpty((Object[])args)) {
            return args;
        }
        ArrayList<Object> convertedValues = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            convertedValues.add(arg instanceof String ? String.format("'%s'", arg) : this.mongoOperations.getConverter().convertToMongoType(arg));
        }
        return convertedValues.toArray();
    }

    private String convertAndJoinScriptArgs(Object ... args) {
        return ObjectUtils.isEmpty((Object[])args) ? "" : StringUtils.arrayToCommaDelimitedString((Object[])this.convertScriptArgs(args));
    }

    private static String generateScriptName() {
        return SCRIPT_NAME_PREFIX + UUID.randomUUID().toString().replaceAll("-", "");
    }
}

