<?php
use \Core\View;
use Helpers\Auth;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <?php }else{ ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><a href="<?=Url::basePath('myAccount/'.$data['userDetails']->{'user-name'})?>"><?=Language::show('user_account', 'keywords')?></a></li>
                <li><?=Language::show('edit_profile', 'keywords')?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <?php if($_SESSION['storageResult'] == 'error'){ ?>
        <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
    <?php }elseif($_SESSION['storageResult'] == 'success'){ ?>
        <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
    <?php } ?>
    <?php $_SESSION['storageResult'] = ''; ?>
    <?php $_SESSION['storageMessage'] = ''; ?>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                    <span class="solutionType" style="display: none;">
                        <?php
                        if((string)$data['userDetails']->{'is-admin'} == 'true'){
                            echo 'Admin';
                        }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                            echo 'Read Only Admin';
                        }else{
                            echo 'User';
                        }
                        ?>
                    </span>
                <div class="col-lg-3">
                    <div class="sidebar">
                        <div class="side-menu">
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'hide';}?>" align="center">
                                    <br/>
                                    <img class="profileImg drop-box"
                                         ngf-select ngf-drop
                                         ng-model="file"
                                         ngf-drag-over-class="dragover"
                                         ngf-multiple="false"
                                         ngf-allow-dir="true"
                                         ngf-keep="false"
                                         ngf-pattern="'.jpg'"
                                         ngf-src="file"
                                         ngf-default-src="'<?=Url::profilePic($data['userDetails']->{'user-name'})?>'"
                                         accept="image/*" ngf-accept="'image/*'">
                                    <div ngf-no-file-drop><?=Language::show('drag_drop_not_supported', 'keywords');?></div>
                                </div>
                            <?php }else{ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'hide';}?>" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic($data['userDetails']->{'user-name'})?>" />
                                </div>
                            <?php } ?>
                            <br/>
                            <div align="center">
                                <ul class="nav wordwrap">
                                    <li><p><?=Language::show('name', 'keywords');?>: <span class="userName"><?=$data['userDetails']->{'user-name'};?></span></p></li>
                                    <li><p><?=Language::show('email', 'keywords');?>: <?=$data['userDetails']->{'email-id'};?></p></li>
                                    <li>
                                        <p>
                                            <?=Language::show('account_type', 'keywords');?>:
                                            <?php
                                            if((string)$data['userDetails']->{'is-admin'} == 'true'){
                                                echo 'Admin';
                                            }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                                                echo 'Read Only Admin';
                                            }else{
                                                echo 'User';
                                            }
                                            ?>
                                        </p>
                                    </li>
                                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-Y h:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?>"><?=Language::show('last_modified_time', 'keywords');?>: <?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-Y', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?></p></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="panel">
                        <div class="panel-heading">
                            <h4><?=Language::show('edit_profile', 'keywords')?></h4>
                        </div>
                        <div class="panel-body">
                            <div class="error col-lg-12" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                            <?= Form::open(array(
                                'method' => 'post',
                                'ng-submit' => 'saveUserDetails()',
                                'class' => 'userSettingsForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            )); ?>
                            <div class="form-group col-lg-6 hide">
                                <label for="user_name"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="user_name" id="user_name" value="<?=$data['userDetails']->{'user-name'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 hide">
                                <label for="password_hash"><?=Language::show('password_hash', 'keywords');?></label>
                                <input type="text" class="form-control" name="password_hash" id="password_hash" value="<?=$data['userDetails']->{'password-hash'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password_hash', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6 hide">
                                <label for="recovery_key"><?=Language::show('recovery_key', 'keywords');?></label>
                                <input type="text" class="form-control" name="recovery_key" id="recovery_key" value="<?=$data['userDetails']->{'recovery-key'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('recovery_key', 'keywords');?>" required autocomplete="off">
                            </div>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6 hide">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="is_first_login" id="is_first_login" required="">
                                        <option value="true" <?php if($data['userDetails']->{'is-first-login'} == 'true'){ ?>selected<?php } ?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-first-login'} == 'false'){ ?>selected<?php } ?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 hide">
                                    <label for="is_first_login"><?=Language::show('is_first_login', 'keywords');?></label>
                                    <input type="text" class="form-control" name="is_first_login" id="is_first_login" value="<?php if($data['userDetails']->{'is-first-login'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('is_first_login', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="account_status" id="account_status" required="">
                                        <option value="true" <?php if($data['userDetails']->{'is-active'} == 'true'){ ?>selected<?php } ?>><?=Language::show('activate', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'is-active'} == 'false'){ ?>selected<?php } ?>><?=Language::show('de_activate', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6">
                                    <label for="account_status"><?=Language::show('account_status', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_status" id="account_status" value="<?php if($data['userDetails']->{'is-active'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('account_status', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php if($data['activateEdit'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                <div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'hide';}?>">
                                    <label for="account_type"><?=Language::show('account_type', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                        <option value="admin" <?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('admin', 'keywords')?></option>
                                        <option value="read_only_admin" <?php if($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo 'selected';}?>><?=Language::show('read_only_admin', 'keywords')?></option>
                                        <option value="user" <?php if($data['userDetails']->{'is-admin'} != 'true' && $data['userDetails']->{'is-readonly-admin'} != 'true'){ echo 'selected';}?>><?=Language::show('user', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 account_type <?php if($data['userDetails']->{'is-active'} == 'false'){echo 'hide';}?>">
                                    <label for="account_type"><?=Language::show('account_type', 'keywords');?></label>
                                    <input type="text" class="form-control" name="account_type" id="account_type" value="<?php if($data['userDetails']->{'is-admin'} == 'true'){ echo 'Admin';}elseif($data['userDetails']->{'is-readonly-admin'} == 'true'){ echo Language::show('read_only_admin','keywords');}else{ echo Language::show('user','keywords');}?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('account_type', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 sync_access <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>" style="margin-bottom: 10px !important;">
                                    <label for="sync_access"><?=Language::show('sync_access', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" required="">
                                        <option value="false" <?php if($data['userDetails']->{'sync-enabled'} =='false'){echo 'selected';}?>><?=Language::show('web_access', 'keywords')?></option>
                                        <option value="true" <?php if($data['userDetails']->{'sync-enabled'} =='true'){echo 'selected';}?>><?=Language::show('epa_web_access', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 sync_access <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                    <label for="sync_access"><?=Language::show('sync_access', 'keywords');?></label>
                                    <input type="text" class="form-control" name="sync_access" id="sync_access" value="<?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo Language::show('epa_web_access', 'keywords'); }else{ echo Language::show('web_access', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('sync_access', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'hide';}?>" style="margin-bottom: 10px !important;">
                                    <label for="backup"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" required="">
                                        <option value="true" <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 backup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('backup') == false){echo 'hide';}?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="backup" id="backup" value="<?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('backup', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'hide';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true" <?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'server-backup-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 serverBackup <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('serverBackup') == false){echo 'hide';}?>">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords');?></label>
                                    <input type="text" class="form-control" name="serverBackup" id="serverBackup" value="<?php if($data['userDetails']->{'server-backup-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('serverBackup', 'keywords');?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <?php
                            $miniClouds = [];
                            if(!empty((array)$data['userDetails']->{'mini-clouds'}->{'mini-cloud'})){
                                foreach($data['userDetails']->{'mini-clouds'}->{'mini-cloud'} as $key => $value){
                                    $miniClouds = array_merge($miniClouds, array((string)$value->{'mini-cloud-name'}));
                                }
                            }
                            ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['miniClouds']->{'mini-cloud'} as $key => $value){ ?>
                                                <option value="<?=$value->{'mini-cloud-name'}?>" <?php if(in_array($value->{'mini-cloud-name'}, $miniClouds)){ echo 'selected';}?>><?=$value->{'mini-cloud-name'}?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php }else{ ?>
                                <?php if(!empty($miniClouds)){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords');?></label>
                                        <input type="text" class="form-control" name="miniCloudName" id="miniCloudName" value="<?=implode(',', $miniClouds);?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('miniCloud', 'keywords');?>" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                            <?php if($data['activateEdit'] == true){ ?>
                                <div class="form-group col-lg-6 hide share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true" <?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo 'selected';}?>><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false" <?php if($data['userDetails']->{'share-enabled'} == 'false'){ echo 'selected';}?>><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <div class="form-group col-lg-6 hide share_enabled <?php if($data['userDetails']->{'is-active'} == 'false' || Auth::checkCloudPermission('sync') == false){echo 'hide';}?>">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <input type="text" class="form-control" name="share_enabled" id="share_enabled" value="<?php if($data['userDetails']->{'share-enabled'} == 'true'){ echo Language::show('enabled', 'keywords'); }else{ echo Language::show('disabled', 'keywords'); } ?>" required autocomplete="off" readonly>
                                </div>
                            <?php } ?>
                            <div class="form-group col-lg-6 <?php if(LDAP_ENABLED == true){echo 'hide';}?>">
                                <label for="email_address"><?=Language::show('email_address', 'keywords');?></label>
                                <input type="email" class="form-control" name="email_address" id="email_address" value="<?=$data['userDetails']->{'email-id'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email_address', 'keywords');?>" required autocomplete="off" <?php if($data['activateEdit'] == false){ echo 'readonly';}?>>
                            </div>
                            <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="odb_login_Id"><?=Language::show('One drive for Business Login Id', 'keywords');?></label>
                                    <input type="email" class="form-control" name="odb_login_Id" id="odb_login_Id" value="<?=$data['userDetails']->{'odb-loginId'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('One drive for Business Login Id', 'keywords');?>" autocomplete="off">
                                </div>
                            <?php } ?>
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <?php if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                                    <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                        <div class="form-group col-lg-12 hide">
                                            <div class="well well-lg">
                                                <h4 style="margin-top: -5px;">Select Storage Space</h4>
                                                <hr/>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                    - Your cloud does not support this feature
                                                </p>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                    - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                </p>
                                                <?php
                                                $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                    - Google Drive Storage space
                                                </p>
                                                <?php
                                                $MODCUrl = ODFC_REDIRECT_URI."?client_id=".ODFC_CLIENT_ID."&response_type=code&redirect_uri=".\Helpers\Url::basePath(ODFC_RESOURCE_URI.'/')."&state=".$data['loggedInUser']['userName'];
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODCUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive</a>
                                                    - Microsoft OneDrive Consumer Storage Space
                                                </p>
                                                <?php
                                                $params = "?resource=".ODFB_RESOURCE_URI."&client_id=".ODFB_CLIENT_ID."&response_type=code&redirect_uri=".ODFB_REDIRECT_URI."&state=".$data['loggedInUser']['userName'];
                                                $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                    - Microsoft OneDrive for business Storage Space
                                                </p>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>

                                <?php if($data['activateEdit'] == true && STORAGE_TYPE == "ONE_DRIVE"){ ?>
<div class="col-lg-12">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>
<?php  if($data['activateEdit'] == true && STORAGE_TYPE !== "ONE_DRIVE"){ ?>
<div class="col-lg-12">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>
<?php  if($data['activateEdit'] == false && STORAGE_TYPE == "ONE_DRIVE"){ ?>
<div class="col-lg-12">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>
<?php  if($data['activateEdit'] == false && STORAGE_TYPE != "ONE_DRIVE"){ ?>
<div class="col-lg-12 hide">
                                   <button type="submit" class="UserSave btn btn-primary pull-right"><?=Language::show('save', 'keywords')?></button>
                               </div>
<?php }?>

                            <?= Form::close(); ?>
                        </div>
                    </div>
                </div>
<?php if(STORAGE_TYPE == "GOOGLE_DRIVE"){ ?>
                 <div class="col-lg-9 <?php if($data['userDetails']->{'externalstorage-authorized'}=='true') { echo 'hide';}?>">
                        <div class="panel">
                                <div class="panel-heading">
                                        <h4 style="margin-top: -5px;">Configure Google Drive</h4>
                                </div>
                                <div class="panel-body">
                                        <?php
$GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
 ?>
                                        <p>

<a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                        </p>
                                </div>
                        </div>
                </div>
                <?php } ?>

<?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                 <div class="col-lg-9 <?php if($data['userDetails']->{'externalstorage-authorized'}=='false') { echo 'hide';}?>">
                        <div class="panel">
                                <div class="panel-heading">
                                        <h4 style="margin-top: -5px;">Configure One Drive</h4>
                                </div>
                                <div class="panel-body">
                                        <?php
$serviceAccount = "true";
$params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$data["clientRedirectURI"]."&state=".$data['loggedInUser']['userName'];
                                                $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                    - Microsoft OneDrive for business Storage Space
                                                </p>
</div>
                        </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
