<?php
use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
if($data['userDetails']->{'sync-enabled'} == 'true' || $data['userDetails']->{'sync-webAccess-enabled'} == 'true'){
    $data['userDetails']->{'sync-enabled'} = 'true';
}
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <?php if(\Helpers\Auth::checkUserPermission('admin')){ ?>
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <?php }else{ ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><?=$data['subPageName']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="col-lg-3">
                    <div class="sidebar">
                        <div class="side-menu">
                            <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'hide';}?>" ng-app="fileUpload" align="center">
                                    <br/>
                                    <img class="profileImg drop-box"
                                         ngf-select ngf-drop
                                         ng-model="file"
                                         ngf-drag-over-class="dragover"
                                         ngf-multiple="false"
                                         ngf-allow-dir="true"
                                         ngf-keep="false"
                                         ngf-src="file"
                                         ngf-pattern="'.jpg'"
                                         ngf-default-src="'<?=Url::profilePic($data['userDetails']->{'user-name'})?>'"
                                         accept="image/*" ngf-accept="'image/*'">
                                    <div ngf-no-file-drop><?=Language::show('drag_drop_not_supported', 'keywords');?></div>
                                </div>
                            <?php }else{ ?>
                                <div class="<?php if(D_PROFILE_PIC == false){echo 'hide';}?>" align="center">
                                    <br/>
                                    <img class="profileImg" src="<?=Url::profilePic($data['userDetails']->{'user-name'})?>" />
                                </div>
                            <?php } ?>
                            <br/>
                            <div align="center">
                                <ul class="nav wordwrap">
                                    <li><p><?=Language::show('name', 'keywords');?>: <span class="userName"><?=$data['userDetails']->{'user-name'};?></span></p></li>
                                    <li><p><?=Language::show('email', 'keywords');?>: <?=$data['userDetails']->{'email-id'};?></p></li>
                                    <li>
                                        <p>
                                            <?=Language::show('account_type', 'keywords');?>:
                                            <?php
                                            if((string)$data['userDetails']->{'is-admin'} == 'true'){
                                                echo 'Admin';
                                            }elseif((string)$data['userDetails']->{'is-readonly-admin'} == 'true'){
                                                echo 'Read Only Admin';
                                            }else{
                                                echo 'User';
                                            }
                                            ?>
                                        </p>
                                    </li>
                                    <li><p class="toolTip" data-placement="bottom" data-toggle="tooltip" title="<?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-Y h:i:s', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?>"><?=Language::show('last_modified_time', 'keywords');?>: <?php if(!empty(((int)$data['userDetails']->{'last-modified-timestamp'}/1000))){echo date('d-M-Y', ((int)$data['userDetails']->{'last-modified-timestamp'}/1000));}else{echo 'NotUpdated';}?></p></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="panel">
                        <div class="panel-heading" style="border-bottom: 1px solid #f0f4f7; padding-bottom: 13px; padding-top: 15px;">
                            <span class="h4"><?=Language::show('profileDisplay', 'user');?></span>
                            <ul class="list list-inline pull-right">
                                <?php if(LDAP_ENABLED == false && $data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                                    <li><a class="btn btn-default btn-small" data-toggle="modal" data-target="#changePassword"><i class="fa fa-key"></i> <?=Language::show('change_password', 'keywords');?></a></li>
                                <?php } ?>
                                <li><a class="btn btn-default btn-small" href="<?=Url::basePath('user/settings/'.$data['userDetails']->{'user-name'})?>"><i class="fa fa-edit"></i> <?=Language::show('edit_profile', 'keywords');?></a></li>
                                <?php if($data['loggedInUser']['admin'] == true && $data['loggedInUser']['userName'] != $data['userDetails']->{'user-name'}){ ?>
                                    <span class="userStatusCollector hide"><?php if($data['userDetails']->{'is-active'} == 'true'){echo true;}?></span>
                                    <li ng-show="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('blockConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="blockUserProfile('<?=$data['userDetails']->{'user-name'};?>', 'true')"
                                           ng-bootbox-confirm-action-cancel=""
                                           href="javascript:;"><i class="fa fa-user-times"></i> <?=Language::show('Block Profile', 'keywords');?></a>
                                    </li>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('unBlockConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="unBlockUserProfile('<?=$data['userDetails']->{'user-name'};?>', 'true')"
                                           ng-bootbox-confirm-action-cancel=""
                                           href="javascript:;"><i class="fa fa-user-plus"></i> <?=Language::show('UnBlock Profile', 'keywords');?></a>
                                    </li>
                                    <li ng-hide="userStatus">
                                        <a class="btn btn-default btn-small"
                                           ng-bootbox-confirm="<?=Language::show('deleteConfirm', 'keywords')?>"
                                           ng-bootbox-confirm-action="deleteUserProfile('<?=$data['userDetails']->{'user-name'};?>', 'true')"
                                           ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('Delete Profile', 'keywords');?></a>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>

                        <div class="panel-body">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="col-lg-8">
                                        <h4>Access Details</h4>
                                        <ul class="list-group">
                                            <?php if($data['userDetails']->{'sync-enabled'} == 'true'){ ?>
                                                <li class="list-group-item"><?=Language::show('sync', 'keywords');?>: <?php if($data['userDetails']->{'sync-enabled'} == 'true'){ echo '<label class="label label-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{ if($data['userDetails']->{'sync-webAccess-enabled'} == 'false'){echo '<label class="label label-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}else{echo '<label class="label label-success pull-right">'.Language::show('Only Web Access', 'keywords').'</label>';}}?></li>
                                            <?php } ?>
                                            <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ ?>
                                                <li class="list-group-item"><?=Language::show('backup', 'keywords');?>: <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ echo '<label class="label label-success pull-right">'.Language::show('enabled', 'keywords').'</label>';}else{echo '<label class="label label-danger pull-right">'.Language::show('disabled', 'keywords').'</label>';}?></li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                    <div class="col-lg-4">
                                        <h4>Storage Details</h4>
                                        <canvas id="storage" width="245" height="150" data-used="{{ userUsed }}" data-free="{{ userFree }}"></canvas>
                                        <span class="help-block text-center">{{ userStorage }} GB* Used, out of {{ userLimit }} GB</span>
                                    </div>
                                </div>
                            </div>
                            <?php if($data['userDetails']->{'backup-enabled'} == 'true'){ ?>
                                <div class="row userDevices" style="display: none;">
                                    <div class="col-lg-12">
                                        <h4><?=Language::show('myDevices', 'user');?></h4>
                                    </div>
                                    <div ng-repeat="value in userDevices track by $index" class="col-lg-4 userDevice{{$index}}" block-ui="myBlockUI{{$index}}">
                                        <div class="panel panel-default no-box-shadow widget-{{ value.background }}">
                                            <div class="background">
                                                <i class="fa fa-{{ value.icon }}"></i>
                                            </div>
                                            <div class="panel-heading widget-header">
                                                <a>{{ value.deviceName }}</a>
                                                <a class="dropdown-toggle pull-right toolTip" data-toggle="dropdown" data-placement="right" title="Details" href="javascript:;"><i class="fa fa-bars"></i></a>
                                                <ul class="dropdown-menu">
                                                    <li class="fileListBtn{{$index}}"><a href="javascrip:;"><?=Language::show('files_list', 'keywords');?></a></li>
                                                    <li><a href="<?=Url::basePath('user/backupHistory/'.$data['userDetails']->{'user-name'}.'/{{ value.deviceUUID }}')?>"><?=Language::show('backup_activity_history', 'keywords');?></a></li>
                                                    <li><a href="<?=Url::basePath('user/device/policyInfo/'.$data['userDetails']->{'user-name'}.'/{{ value.deviceUUID }}/{{ value.icon }}')?>"><?=Language::show('policy_configuration', 'keywords');?></a></li>
                                                </ul>
                                                <a class="pull-right eye" ng-click="viewDeviceDetails($index, value.deviceUUID)" href="javascript:;"><i class="fa fa-eye"></i></a>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i ng-click="viewDeviceDetails($index, value.deviceUUID)" class="clickAble fa fa-{{ value.icon }}"></i>
                                                <a style="font-size: 25px;margin-top: -10px; margin-right: 13px;" class="pull-right" ng-cloak>{{ value.storageUsedByDevice }}*</a>
                                                <div class="row expandDetails{{$index}}" style="font-size: 10px; color: #FFFFFF; display: none;">
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <p>Last Successful Backup:
                                                            <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup == null" ng-cloak>Not completed yet</b>
                                                            <b class="pull-right" ng-if="deviceDetails.lastSuccessBackup != null" ng-cloak>{{deviceDetails.lastSuccessBackup}}</b>
                                                        </p>
                                                        <p>Next Scheduled Backup: <b class="pull-right" ng-cloak>{{deviceDetails.nextScheduledBackup}}</b></p>
                                                        <p>Policy Refresh Frequency: <b class="pull-right" ng-cloak>{{deviceDetails.nextPolicyRefresh}} hours</b></p>
                                                    </div>
                                                    <div class="col-lg-6" style="padding: 30px 10px 10px 35px;">
                                                        <p>Operating System: <b class="pull-right" ng-cloak>{{deviceDetails.osType.replace("(unknown)", "");}}</b></p>
                                                        <p>End Point Agent Version: <b class="pull-right" ng-cloak>{{deviceDetails.productVersion}}</b></p>
                                                        <p>Storage Media: <b class="pull-right" ng-cloak>{{deviceDetails.storageMedia}}</b></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="h4 loading text-center">Loading ...</div>
                            <?php } ?>
                        </div>
                        <div class="panel-footer">
                            <span class="help-block">Note:- * size includes the sizes of earlier file versions</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="changePassword" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <?= Form::open(array(
                    'ng-submit' => 'changePassword()',
                    'id' => 'changePasswordForm',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Change Password</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" class="form-control" id="password" placeholder="Enter a Password" data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
                    </div>
                    <div class="form-group">
                        <label for="rePassword">Re Type Password</label>
                        <input type="password" name="rePassword" class="form-control" id="rePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="changePasswordBtn" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>