<?php

use \Core\View;
use \Helpers\Url;
use \Core\Language;

/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
               <li><h3><a href="<?=Url::basePath('support')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SupportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="panel" style="padding: 15px 5px 5px 5px ;">
                <div class="panel-heading">
                    <h3 style="margin-top: 0px;">Support Log Details</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <ul class="list-group col-lg-6">
                            <li class="list-group-item">User ID <p class="pull-right" ng-cloak><?=$data['support']->{'userName'}?></p></li>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                            <li class="list-group-item">Server Name <p class="pull-right" ng-cloak><?=$data['support']->{'deviceName'}?></p></li>
                             <?php } else {  ?>
                            <li class="list-group-item">Device ID <p class="pull-right" ng-cloak><?=$data['support']->{'deviceName'}?></p></li>
                            <?php } ?>
                            <li class="list-group-item">Date <p class="pull-right" ng-cloak><?=date('d-M-Y h:i:s', (((int)$data['support']->{'timeStamp'}) / 1000))?></p></li>
                            <li class="list-group-item">Support ID <p class="pull-right" ng-cloak><?=$data['support']->{'id'}?></p></li>
                            
                            
                            
                        </ul>
                    </div>
                    <?php if(!empty($data['support']->{'logFiles'})){ ?>
                        <hr />
                        <div class="row">
                            <div class="col-lg-12">
                                <?php foreach($data['support']->{'logFiles'} as $key => $value){ ?>
                                    <?php
                                        if(strpos((string)$value->{'filename'}, 'debug') !== false){
                                            $icon = 'bug';
                                        }elseif(strpos((string)$value->{'filename'}, 'warn') !== false){
                                            $icon = 'warning';
                                        }elseif(strpos((string)$value->{'filename'}, 'info')){
                                            $icon = 'info';
                                        }else{
                                            $icon = 'times-circle';
                                        }
                                        $size   = $value->{'size'};
                                        $sym    = 'KB';
                                        $size   = $size/1024;
                                        $remainder = $size / 1024;
                                        if (intval($remainder) > 0){
                                            $size = $size/1024;
                                            $sym = 'MB';
                                        }
                                        $logSize = round($size).'&nbsp;'.$sym;
                                    ?>
                                    <div class="col-lg-3">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="downloadLog('<?=Url::basePath('downloadLog/'.$data['support']->{'id'}.'/'.$value->{'filename'})?>')">
                                            <div class="background">
                                                <i class="fa fa-<?=$icon?>"></i>
                                            </div>
                                            <div class="panel-body widget widget-body">
                                                <i class="fa fa-<?=$icon?>" style="font-size: 15px;"> <?=$value->{'filename'}?>(<?=$logSize?>)</i><br>
                                                <a><?=date('d-M-Y h:i:s', (((int)$value->{'lastModified'}) / 1000))?></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    <?php }else{ ?>
                        <div class="row">
                            <div class="col-lg-12">
                                <h4>There were no log files found to download</h4>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SupportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
