<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Proxy Configuration</h4>
                    </div>
                    <div class="panel-body">
                        <form class="proxyConfiguration" ng-submit="saveProxyConfiguration()" data-parsley-validate>
                            <div class="form-group col-lg-6">
                                <label for="proxyURL">Proxy URL</label>
                                <input type="text" class="form-control" name="proxyURL" id="proxyURL" value="<?=$data['proxy'][0]->{"host"}?>" placeholder="Enter your proxy Url" required autocomplete="off"<?php if($data['proxy']) {?>readonly<?php }?>>
                                <span class="help-line text-muted hide">Note:- Enter the complete proxy URL, example:- http://www.example.com</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="proxyPort">Proxy Port</label>
                                <input type="text" class="form-control" name="proxyPort" id="proxyPort" value="<?=$data['proxy'][0]->{"port"}?>" placeholder="Enter your Port" required autocomplete="off">
                                <span class="help-line text-muted hide">Note:- Enter the complete proxy Port</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="proxyUserName">Account Username</label>
                                <input type="text" class="form-control" name="proxyUserName" id="proxyUserName" value="<?=$data['proxy'][0]->{"userName"}?>" placeholder="Enter your Proxy Username" required autocomplete="off">
                                <span class="help-line text-muted hide">Note:- Enter your username which is used to login to your proxy server</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="proxyPassword">Account password</label>
                                <input type="password" class="form-control" name="proxyPassword" id="proxyPassword" value="<?=$data['proxy'][0]->{"password"}?>" placeholder="Enter your Proxy Password" required autocomplete="off">
                                <span class="help-line text-muted hide">Note:- Enter your Proxy server password which is used to login to you proxy server</span>
                                <br/><br/>
                                <?php if($data['proxy']) {?>
                                    <a class="btn btn-danger pull-right proxyRemove" ng-click="removeProxyConfiguration()"><?=Language::show('delete', 'keywords');?></a>
                                    <a style="margin-right: 5px;" class="btn btn-success pull-right eproxySave" ng-click="editProxyConfiguration()">Save</a>
                                <?php } else {?>
                                <button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right proxySave">Save</button>
                                <?php }?>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>

