<?php use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ServerController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4>
                            <?=$data['crumb1']?>
                        </h4>
                    </div>
                    <div class="panel-body">
                        <?=
                        Form::open(array(
                            'ng-submit' => 'saveNewUserDetails()',
                            'method' => 'post',
                            'class' => 'userCreationFrom',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="row">
                            <div class="form-group col-lg-12">
                                <label for="username"><?=Language::show('serverName', 'keywords');?></label>
                                <input type="text" class="form-control" name="username" id="username" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('serverName', 'keywords');?>" required autocomplete="off">
                            </div>
                            <div class="form-group hide col-lg-6">
                                <label for="email"><?=Language::show('email', 'keywords');?></label>
                                <input type="text" class="form-control" name="email" id="email" value="<?=substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789',5)),0,5).'@parablu.com';?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email', 'keywords');?>" required autocomplete="off" data-parsley-type="email">
                            </div>
                        </div>
                        <div class="row hide">
                            <div class="form-group col-lg-6">
                                <label for="password"><?=Language::show('password', 'keywords');?></label>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" value="<?='Parablu@123'?>" data-parsley-trigger="change">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="rePassword"><?=Language::show('rePassword', 'keywords');?></label>
                                <input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change" value="<?='Parablu@123'?>">
                            </div>
                        </div>
                        <?php if($data['loggedInUser']['syncWebAccessEnabled'] == true && $data['loggedInUser']['syncEnabled'] == true){ ?>
                            <div class="row hide">
                                <div class="form-group col-lg-6 sync_access">
                                    <label for="sync_access"><?=Language::show('sync_access', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" required="">
                                        <option selected value="false"><?=Language::show('web_access', 'keywords')?></option>
                                        <option value="true"><?=Language::show('epa_web_access', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 share_enabled">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="share_enabled" id="share_enabled" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option selected value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="row hide">
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-12 miniCloudName">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['miniClouds']->{'mini-cloud'} as $key => $value){ ?>
                                                <option><?=$value->{'mini-cloud-name'}?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } ?>
                        <div class="row hide">
                            <div class="form-group col-lg-6 account_type">
                                <label for="account_type"><?=Language::show('account_type', 'keywords')?></label>
                                <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                    <option value="user"><?=Language::show('user', 'keywords')?></option>
                                    <option selected value="admin"><?=Language::show('admin', 'keywords')?></option>
                                    <option value="read_only_admin"><?=Language::show('read_only_admin', 'keywords')?></option>
                                </select>
                            </div>
                            <?php if($data['loggedInUser']['backupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 backup">
                                    <label for="backup"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option selected value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php } ?>
                            <?php if($data['loggedInUser']['serverBackupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option selected value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="form-group col-lg-12">
                            <button type="submit" class="userSave btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                        Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ServerController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>