<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?='Dashboard'?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-12 col-md-12 col-sm-12 ng-cloak">
            <?php if(!empty($_SESSION['OverReportResult'])){ ?>
                <?php if($_SESSION['OverReportResult'] == 404){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 404</span>
                <?php }elseif($_SESSION['OverReportResult'] == 500){ ?>
                    <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 500</span>
                <?php } ?>
                <?php $_SESSION['OverReportResult'] = ''; ?>
            <?php } ?>
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='overview'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h3><?=$data['crumb1']?>
                            <span class="overviewJobTime" ng-if="overviewJobTime.length > 0" style="font-size: 14px; display: none;">- SnapShot Timestamp: {{ overviewJobTime }}</span>
                        </h3>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form ng-submit="searchUserInOverView(search.userName)">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <label for="searchUsername">User Name</label>
                                            <select name="searchUsername"
                                                    style="width: 100%;"
                                                    class="pull-right form-control searchUsername"
                                                    ng-model="search.userName"
                                                    placeholder="Enter a 'username' and hit enter to search"
                                                    data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                    data-content="Entered username was not found!!! ">
                                                <option value="all" selected>all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="searchDeviceName">Device name</label>
                                            <select class="searchDeviceName form-control" readonly>
                                                <option value="all">all</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <button style="margin-top: 25px" type="submit" class="btn tbn-default">View</button>
                                            <a style="margin-top: 25px" class="btn btn-default" href="<?=Url::basePath('report/download/overviewReport?from=overview')?>">Download</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center">Loading.....</div>
                        <table class="table-bordered overviewListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'userId'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="overviewSortType == 'userId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'userId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'emailId'; sortReverse = !sortReverse">
                                    <?=Language::show('email_address', 'keywords')?>
                                    <span ng-show="overviewSortType == 'emailId' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'emailId' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="overviewSortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'policyName'; sortReverse = !sortReverse">
                                    <?=Language::show('policyName', 'keywords')?>
                                    <span ng-show="overviewSortType == 'policyName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'policyName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'epaInstallationDate'; sortReverse = !sortReverse">
                                    <?=Language::show('epaInstallationDate', 'keywords')?>
                                    <span ng-show="overviewSortType == 'epaInstallationDate' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'epaInstallationDate' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'firstBkpStartTime'; sortReverse = !sortReverse">
                                    <?=Language::show('firstBackupStartTime', 'keywords')?>
                                    <span ng-show="overviewSortType == 'firstBkpStartTime' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'firstBkpStartTime' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'lastBkpStartTime'; sortReverse = !sortReverse">
                                    <?=Language::show('lastBackupStartTime', 'keywords')?>
                                    <span ng-show="overviewSortType == 'lastBkpStartTime' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'lastBkpStartTime' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'lastSuccessfulBkp'; sortReverse = !sortReverse">
                                    <?=Language::show('lastSuccessfulBackup', 'keywords')?>
                                    <span ng-show="overviewSortType == 'lastSuccessfulBkp' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'lastSuccessfulBkp' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'reason'; sortReverse = !sortReverse">
                                    <?=Language::show('lastBackupStatus', 'keywords')?>
                                    <span ng-show="overviewSortType == 'reason' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'reason' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'storageUtilized'; sortReverse = !sortReverse">
                                    <?=Language::show('totalStorageUtilized', 'keywords')?>
                                    <span ng-show="overviewSortType == 'storageUtilized' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'storageUtilized' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="overviewSortType = 'completedPercentage'; sortReverse = !sortReverse">
                                    <?=Language::show('percentageOfFilesBackedUp', 'keywords')?>
                                    <span ng-show="overviewSortType == 'completedPercentage' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="overviewSortType == 'completedPercentage' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in overview | orderBy:overviewSortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.userId }}</td>
                                <td ng-cloak>{{ value.emailId }}</td>
                                <td ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.policyName }}</td>
                                <td ng-cloak>{{ value.epaInstallationDate }}</td>
                                <td ng-cloak>{{ value.firstBkpStartTime }}</td>
                                <td ng-cloak>{{ value.lastBkpStartTime }}</td>
                                <td ng-cloak>{{ value.lastSuccessfulBkp }}</td>
                                <td ng-cloak ng-if="value.lastBkpStatus =='STARTED'">STARTED</td>
                                <td ng-cloak ng-if="value.lastBkpStatus !='STARTED'">{{ value.reason }}</td>
                                <td ng-cloak>{{ value.storageUtilized }}</td>
                                <td ng-cloak>{{ value.completedPercentage }}</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'overview')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchUsername').select2({
        ajax: {
            url: "<?=DIR?>"+"user/searchUserWithDevice",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic, devices: o.devices };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 3,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select user'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        if(users.devices != undefined) {
            if (users.devices.length > 0){
                $('.searchDeviceName').removeAttr("readonly", "readonly");
                var options = "";
                users.devices.forEach(function (device) {
                    options += '<option value="' + device + '">' + device + '</option>'
                });
                $('.searchDeviceName').html(options);
            }else {
                $('.searchDeviceName').html("<option value='all' selected>User has no devices configured</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }else{
            if(users.text == "all"){
                $('.searchDeviceName').html("<option selected>all</option>");
                $('.searchDeviceName').attr("readonly", "readonly");
            }
        }
        return users.text;
    }
</script>
