<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=Language::show('list_of_schedules', 'keywords');?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='schedule'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('list_of_schedules', 'keywords');?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/schedule/create')?>"><?=Language::show('create_schedule', 'keywords');?></a></span></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-6">
                                    <col class="col-xs-1">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th><?=Language::show('scheduleName', 'keywords')?></th>
                                        <th><?=Language::show('scheduleStartTime', 'keywords')?></th>
                                        <th><?=Language::show('schedule_days', 'keywords')?></th>
                                        <th><?=Language::show('action', 'keywords')?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in schedules track by $index">
                                        <td ng-cloak>{{ value.scheduleName }}</td>
                                        <td ng-cloak>{{ value.time }}</td>
                                        <td ng-cloak>{{ value.days }}</td>
                                        <td ng-cloak><a class="btn btn-default btn-small" ng-click="scheduleEdit($index)"><?=Language::show('edit_schedule', 'keywords')?></a></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade editSchedule">
            <div class="modal-dialog">
                <div class="modal-content mediumModal">
                    <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'scheduleForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'scheduleSave()',
                            'data-parsley-validate' => true
                        ));
                    ?>
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Edit Schedule</h4>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                            <input type="text" class="form-control" value="{{ schedules[scheduleIndex].scheduleName }}" readonly name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group hide">
                            <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                            <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group">
                            <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                            <input type="text" class="form-control scheduleEditTime input-small" id="scheduleStartTime" name="scheduleStartTime">
                        </div>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                            <div class="form-group backupTypeForm">
                                <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                                <select class="form-control backupType" name="backupType" id="backupType" required>
                                    <option value="f">Full</option>
                                    <option value="i">Incremental</option>
                                </select>
                            </div>
                        <?php } ?>
                        <div class="form-group">
                            <label for="days"><?=Language::show('schedule_days', 'keywords');?></label>
                            <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                            <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                                <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                <option value="6"><?=Language::show('friday', 'keywords')?></option>
                                <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                            </select>
                        </div>
                        <div>
                            <p>Note:- The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating.</p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('cancel', 'keywords')?></button>
                        <button type="submit" class="btn btn-primary"><?=Language::show('save', 'keywords')?></button>
                    </div>
                    <?= Form::close(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.backupType').selectpicker('render');
    $('.scheduleEditTime').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
