<?php

use Core\Language;
use \Core\View;
use \Helpers\Url;

 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['subPageName']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row dashboard">
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-users"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Active Users</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-users"></i>
                            <a class="pull-right hide" ng-cloak><span>{{ statistics.usersConnected }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-purple">
                        <div class="background">
                            <i class="fa fa-desktop"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Active Devices</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-desktop"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.devicesConnected }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-danger">
                        <div class="background">
                            <i class="fa fa-refresh"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Average restores per user</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-refresh"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.avgRestorePerUser }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-primary">
                        <div class="background">
                            <i class="fa fa-database"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Completed Backups</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-database"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.backupsDone }}</span></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-warning">
                        <div class="background">
                            <i class="fa fa-hdd-o"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Total size of Data Backed up</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-hdd-o"></i>
                            <a class="pull-right hide" ng-cloak>{{ statistics.totalStorageUtilized }}</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-primary">
                        <div class="background">
                            <i class="fa fa-recycle"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Completed Restores</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-recycle"></i>
                            <a class="pull-right hide"><span ng-cloak>{{ statistics.restoresDone }}</span></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4" block-ui="myBlockUI">
                    <div class="panel panel-default no-box-shadow widget-success">
                        <div class="background">
                            <i class="fa fa-inbox"></i>
                        </div>
                        <div class="panel-heading widget-header">
                            <a>Average Storage Utilized per user</a>
                        </div>
                        <div class="panel-body widget widget-body">
                            <i class="fa fa-inbox"></i>
                            <a class="pull-right hide" ng-cloak>{{ statistics.avgStoragePerUser }}</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Currently Running Backups </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
                            <table id="CurrentBackup" class="table table-bordered currentBackup" style="display: none;">
                                <thead>
                                <tr>
                                    <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('user', 'keywords')?>
                                        <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                        <?=Language::show('device', 'keywords')?>
                                        <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr ng-repeat="value in currentBackup | orderBy:sortType:sortReverse" class="text-center">
                                    <td ng-cloak>{{ value.userName }}</td>
                                    <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                </tr>
                                </tbody>
                            </table>
                            <div class="h4 currentBackupError text-center" style="display: none">There was not details found for Current Backup</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Reports </h3>
                        </div>
                        <hr/>
                        <div class="panel-body">
                            <p><a href="<?=Url::basePath('report/overview')?>"> Backup Overview </a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/userBackupHistory')?>"> Backup History </a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/failedBackup')?>"> Failed Backup History</a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Systems without backups</a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Servers without backups</a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/restoreByDate')?>"> Restore History</a></p>
                            <p><a href="<?=Url::basePath('report/dailyUserBackupOverview')?>"> Storage Utilization Report</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
